/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.swauth;

import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.client.swauth.SwiftAuthClientException;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class SwiftAuthClient {
    private String authURL;
    private String username;
    private String password;
    private String authToken;
    private String storageURL;
    private HttpClient client;

    public SwiftAuthClient(HttpClient client, String authUrl, String username, String password) {
        this.client = client;
        this.authURL = authUrl;
        this.username = username;
        this.password = password;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getStorageURL() {
        return this.storageURL;
    }

    public void dispose() {
        HttpClientUtil.disposeHttpClient((HttpClient)this.client);
    }

    public void login() throws IOException, SwiftAuthClientException {
        HttpResponse response = null;
        try {
            HttpGet method = new HttpGet(this.authURL);
            method.setHeader("X-Auth-User", this.username);
            method.setHeader("X-Auth-Key", this.password);
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                this.authToken = response.getFirstHeader("X-Auth-Token") != null ? response.getFirstHeader("X-Auth-Token").getValue() : null;
                this.storageURL = response.getFirstHeader("X-Storage-Url") != null ? response.getFirstHeader("X-Storage-Url").getValue() : null;
                return;
            }
            throw new SwiftAuthClientException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public boolean check() {
        if (this.storageURL == null || this.authToken == null) {
            return false;
        }
        try {
            HttpHead method = new HttpHead(this.storageURL);
            method.setHeader("X-Auth-Token", this.authToken);
            HttpResponse response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }
}

