/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.swauth;

import com.intel.cosbench.api.auth.AuthException;
import com.intel.cosbench.api.auth.AuthTimeoutException;
import com.intel.cosbench.api.auth.NoneAuth;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.swauth.SwiftAuthContext;
import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.client.swauth.SwiftAuthClient;
import com.intel.cosbench.client.swauth.SwiftAuthClientException;
import com.intel.cosbench.client.swauth.SwiftAuthConstants;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import org.apache.http.client.HttpClient;

class SwiftAuth
extends NoneAuth {
    private SwiftAuthClient client;
    private String url;
    private String username;
    private String password;
    private int timeout;

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.url = config.get("auth_url", config.get("url", "http://127.0.0.1:8080/auth/v1.0"));
        this.username = config.get("username", "");
        this.password = config.get("password", "");
        this.timeout = config.getInt("timeout", SwiftAuthConstants.CONN_TIMEOUT_DEFAULT.intValue());
        this.parms.put("auth_url", (Object)this.url);
        this.parms.put("username", (Object)this.username);
        this.parms.put("password", (Object)this.password);
        this.parms.put("timeout", (Object)this.timeout);
        logger.debug("using auth config: {}", (Object)this.parms);
        HttpClient httpClient = HttpClientUtil.createHttpClient((int)this.timeout);
        this.client = new SwiftAuthClient(httpClient, this.url, this.username, this.password);
        logger.debug("swauth client has been initialized");
    }

    public void init() {
        super.init();
        this.logger.debug("a second init of client using auth config: {}", (Object)this.parms);
        HttpClient httpClient = HttpClientUtil.createHttpClient((int)this.timeout);
        this.client = new SwiftAuthClient(httpClient, this.url, this.username, this.password);
        this.logger.debug("a second swauth client has been initialized");
    }

    public void dispose() {
        super.dispose();
        this.client.dispose();
    }

    public AuthContext login() {
        super.login();
        try {
            this.client.login();
        }
        catch (SwiftAuthClientException se) {
            throw new AuthTimeoutException((Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new AuthException((Throwable)e);
        }
        return this.createContext();
    }

    private AuthContext createContext() {
        SwiftAuthContext context = new SwiftAuthContext(this.url, this.username, this.password, this.client.getAuthToken(), this.client.getStorageURL());
        return context;
    }
}

