/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.http;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpClientUtil {
    public static HttpClient createHttpClient(int timeout) {
        BasicHttpParams params = new BasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams((HttpParams)params);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"cosbench/2.0");
        SchemeRegistry sr = new SchemeRegistry();
        sr.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        sr.register(new Scheme("https", 443, (SchemeSocketFactory)HttpClientUtil.createSSLSocketFactory()));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(sr);
        return new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            ctx.init(null, new X509TrustManager[]{tm}, null);
            String[] enabled = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
            ctx.createSSLEngine().setEnabledCipherSuites(enabled);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return ssf;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void disposeHttpClient(HttpClient client) {
        if (client != null) {
            ClientConnectionManager manager = client.getConnectionManager();
            manager.shutdown();
            client = null;
        }
    }

    public static HttpGet makeHttpGet(String url) {
        return new HttpGet(url);
    }

    public static HttpPut makeHttpPut(String url) {
        return new HttpPut(url);
    }

    public static HttpHead makeHttpHead(String url) {
        return new HttpHead(url);
    }

    public static HttpPost makeHttpPost(String url) {
        return new HttpPost(url);
    }

    public static HttpDelete makeHttpDelete(String url) {
        return new HttpDelete(url);
    }

    public static String encodeURL(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(str).replaceAll("\\+", "%20");
        }
        catch (EncoderException encoderException) {
            return str;
        }
    }
}

