/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.openio;

import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import io.openio.sds.Client;
import io.openio.sds.ClientBuilder;
import io.openio.sds.exceptions.ContainerExistException;
import io.openio.sds.exceptions.ContainerNotEmptyException;
import io.openio.sds.exceptions.SdsException;
import io.openio.sds.models.ListOptions;
import io.openio.sds.models.ObjectInfo;
import io.openio.sds.models.ObjectList;
import io.openio.sds.models.OioUrl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenIOStorage
extends NoneStorage {
    private Client client;
    private String account;
    private Pattern errCodePattern = Pattern.compile(".*(\\p{Digit}{3}).*");

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        String ns = config.get("ns");
        String proxydurl = config.get("proxyd-url");
        this.client = ClientBuilder.newClient((String)ns, (String)proxydurl);
        this.account = config.get("account");
        this.parms.put("ns", (Object)ns);
        this.parms.put("proxyd-url", (Object)proxydurl);
        this.parms.put("account", (Object)this.account);
    }

    private StorageException makeStorageException(SdsException wrapped) {
        String origMsg = wrapped.getMessage();
        if (wrapped instanceof ContainerNotEmptyException || wrapped instanceof ContainerExistException) {
            return new StorageException("HTTP/1.1 409 " + origMsg, (Throwable)wrapped);
        }
        Matcher codeMatcher = this.errCodePattern.matcher(origMsg);
        if (codeMatcher.find()) {
            return new StorageException("HTTP/1.1 " + codeMatcher.group(1) + " " + origMsg, (Throwable)wrapped);
        }
        return new StorageException("HTTP/1.1 500 " + origMsg, (Throwable)wrapped);
    }

    public InputStream getObject(String container, String object, Config config) {
        try {
            ObjectInfo oinf = this.client.getObjectInfo(OioUrl.url((String)this.account, (String)container, (String)object));
            return this.client.downloadObject(oinf);
        }
        catch (SdsException e) {
            throw this.makeStorageException(e);
        }
    }

    public InputStream getList(String container, String object, Config config) {
        StringBuilder sb = new StringBuilder();
        try {
            ObjectList objects = this.client.listContainer(OioUrl.url((String)this.account, (String)container), new ListOptions());
            for (ObjectList.ObjectView obj : objects.objects()) {
                sb.append(obj.name()).append('\n');
            }
        }
        catch (SdsException e) {
            throw this.makeStorageException(e);
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        try {
            this.client.createContainer(OioUrl.url((String)this.account, (String)container));
        }
        catch (ContainerExistException e) {
            this.logger.warn("Container " + container + " already exists!", (Throwable)e);
        }
        catch (SdsException e) {
            throw this.makeStorageException(e);
        }
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        try {
            this.client.putObject(OioUrl.url((String)this.account, (String)container, (String)object), Long.valueOf(length), data);
        }
        catch (SdsException e) {
            throw this.makeStorageException(e);
        }
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        try {
            this.client.deleteContainer(OioUrl.url((String)this.account, (String)container));
        }
        catch (SdsException e) {
            throw this.makeStorageException(e);
        }
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        try {
            this.client.deleteObject(OioUrl.url((String)this.account, (String)container, (String)object));
        }
        catch (SdsException e) {
            throw this.makeStorageException(e);
        }
    }
}

