/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.mock;

import com.intel.cosbench.log.Logger;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;

class Profile {
    private static final DecimalFormat FT = new DecimalFormat("00.00%");
    private String name;
    private AtomicInteger total;
    private ConcurrentMap<String, AtomicInteger> counters;

    public Profile(String name) {
        this.name = name;
        this.total = new AtomicInteger(0);
        this.counters = new ConcurrentSkipListMap<String, AtomicInteger>();
    }

    public void addEvent(String key) {
        this.total.getAndIncrement();
        if (!this.counters.containsKey(key)) {
            this.counters.putIfAbsent(key, new AtomicInteger(0));
        }
        ((AtomicInteger)this.counters.get(key)).getAndIncrement();
    }

    public void printStat(double all, Logger logger) {
        double sum = this.total.doubleValue();
        logger.debug("----------- " + this.name + " Statistic ----------");
        for (Map.Entry entry : this.counters.entrySet()) {
            int value = ((AtomicInteger)entry.getValue()).intValue();
            logger.debug("[" + (String)entry.getKey() + "] [" + value + "] [" + FT.format((double)value / sum) + "]");
        }
        logger.debug("-----------------------------------");
        logger.debug("Total Ops: " + this.total.intValue() + " (" + FT.format((double)this.total.intValue() / all) + ")");
        logger.debug("-----------------------------------");
    }
}

