/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.mock;

import com.intel.cosbench.api.mock.MockConstants;
import com.intel.cosbench.api.mock.MockUtils;
import com.intel.cosbench.api.mock.Statistics;
import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.io.input.NullInputStream;

class MockStorage
extends NoneStorage {
    private Random random = new Random();
    private Statistics stats = new Statistics();
    private long size;
    private long delay;
    private double errors;
    private boolean printing;
    private boolean profiling;
    private volatile Thread thread;

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.stats.addProfile("GET");
        this.stats.addProfile("PUT");
        this.stats.addProfile("DEL");
        logger.debug("op profiling data has been initialized");
        this.size = config.getLong("size", (long)MockConstants.OBJECT_SIZE_DEFAULT.intValue());
        this.delay = config.getLong("delay", MockConstants.OP_DELAY_DEFAULT.longValue());
        this.errors = config.getDouble("errors", MockConstants.OP_ERRORS_DEFAULT.doubleValue());
        this.printing = config.getBoolean("printing", MockConstants.PRINTING_DEFAULT.booleanValue());
        this.profiling = config.getBoolean("doStats", MockConstants.PROFILING_DEFAULT.booleanValue());
        this.parms.put("size", (Object)this.size);
        this.parms.put("delay", (Object)this.delay);
        this.parms.put("errors", (Object)this.errors);
        this.parms.put("printing", (Object)this.printing);
        this.parms.put("doStats", (Object)this.profiling);
        logger.debug("using storage config: {}", (Object)this.parms);
        logger.debug("mock client has been initialized");
    }

    public void dispose() {
        super.dispose();
        if (this.profiling && this.logger.isDebugEnabled()) {
            this.stats.printStats(this.logger);
        }
        this.thread = null;
    }

    public void abort() {
        super.abort();
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    public InputStream getObject(String container, String object, Config config) {
        super.getObject(container, object, config);
        if (this.profiling && this.logger.isDebugEnabled()) {
            this.stats.addEvent("GET", String.valueOf(container) + "/" + object);
        }
        if (this.random.nextDouble() < this.errors) {
            throw new StorageException("error injection");
        }
        this.thread = Thread.currentThread();
        MockUtils.sleep(this.delay);
        return new NullInputStream(this.size);
    }

    public InputStream getList(String container, String object, Config config) {
        super.getList(container, object, config);
        if (this.profiling && this.logger.isDebugEnabled()) {
            this.stats.addEvent("LIST", String.valueOf(container) + "/" + object);
        }
        if (this.random.nextDouble() < this.errors) {
            throw new StorageException("error injection");
        }
        this.thread = Thread.currentThread();
        MockUtils.sleep(this.delay);
        return new NullInputStream(0L);
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        if (this.random.nextDouble() < this.errors) {
            throw new StorageException("error injection");
        }
        this.thread = Thread.currentThread();
        MockUtils.sleep(this.delay);
    }

    @Deprecated
    public void createObject(String container, String object, byte[] data, Config config) {
        super.createObject(container, object, data, config);
        if (this.profiling && this.logger.isDebugEnabled()) {
            this.stats.addEvent("PUT", String.valueOf(container) + "/" + object);
        }
        if (this.random.nextDouble() < this.errors) {
            throw new StorageException("error injection");
        }
        if (this.printing) {
            this.logger.debug("content to upload: " + MockUtils.toString(data));
        }
        this.thread = Thread.currentThread();
        MockUtils.sleep(this.delay);
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        if (this.profiling && this.logger.isDebugEnabled()) {
            this.stats.addEvent("PUT", String.valueOf(container) + "/" + object);
        }
        if (this.random.nextDouble() < this.errors) {
            throw new StorageException("error injection");
        }
        if (this.printing) {
            this.logger.debug("content to upload: " + MockUtils.toString(data));
        } else {
            MockUtils.consume(data);
        }
        this.thread = Thread.currentThread();
        MockUtils.sleep(this.delay);
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        if (this.random.nextDouble() < this.errors) {
            throw new StorageException("error injection");
        }
        this.thread = Thread.currentThread();
        MockUtils.sleep(this.delay);
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        if (this.profiling && this.logger.isDebugEnabled()) {
            this.stats.addEvent("DEL", String.valueOf(container) + "/" + object);
        }
        if (this.random.nextDouble() < this.errors) {
            throw new StorageException("error injection");
        }
        this.thread = Thread.currentThread();
        MockUtils.sleep(this.delay);
    }
}

