/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.mock;

import com.intel.cosbench.api.auth.NoneAuth;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.context.DefaultAuthContext;
import com.intel.cosbench.api.mock.MockConstants;
import com.intel.cosbench.api.mock.MockUtils;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;

class MockAuth
extends NoneAuth {
    private String token;
    private long delay;

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.token = config.get("token", "token");
        this.delay = config.getLong("delay", MockConstants.OP_DELAY_DEFAULT.longValue());
        this.parms.put("token", (Object)this.token);
        this.parms.put("delay", (Object)this.delay);
        logger.debug("using auth config: {}", (Object)this.parms);
        logger.debug("mock auth has been initialized");
    }

    public AuthContext login() {
        super.login();
        MockUtils.sleep(this.delay);
        DefaultAuthContext context = new DefaultAuthContext();
        context.put("token", (Object)this.token);
        return context;
    }
}

