/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.storage;

import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.context.Context;
import com.intel.cosbench.api.storage.StorageAPI;
import com.intel.cosbench.api.storage.StorageConstants;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

public class NoneStorage
implements StorageAPI {
    public static final String API_TYPE = "none";
    protected Context parms;
    protected Logger logger;
    protected Boolean authFlag;
    private boolean logging;

    @Override
    public void init(Config config, Logger logger) {
        this.logger = logger;
        this.parms = new Context();
        this.logging = config.getBoolean("logging", StorageConstants.LOGGING_DEFAULT.booleanValue());
        this.parms.put("logging", this.logging);
        this.authFlag = false;
    }

    @Override
    public void setAuthContext(AuthContext info) {
        this.setAuthFlag(true);
    }

    @Override
    public AuthContext getAuthContext() {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Context getParms() {
        return this.parms;
    }

    @Override
    public void abort() {
    }

    @Override
    public InputStream getObject(String container, String object, Config config) {
        if (this.logging) {
            this.logger.info("performing GET at /{}/{}", (Object)container, (Object)object);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public InputStream getList(String container, String object, Config config) {
        if (this.logging) {
            this.logger.info("performing LIST at /{}/{}", (Object)container, (Object)object);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public void createContainer(String container, Config config) {
        if (this.logging) {
            this.logger.info("performing PUT at /{}", (Object)container);
        }
    }

    @Deprecated
    public void createObject(String container, String object, byte[] data, Config config) {
        if (this.logging) {
            this.logger.info("performing PUT at /{}/{}", (Object)container, (Object)object);
        }
    }

    @Override
    public void createObject(String container, String object, InputStream data, long length, Config config) {
        if (this.logging) {
            this.logger.info("performing PUT at /{}/{}", (Object)container, (Object)object);
        }
    }

    @Override
    public void deleteContainer(String container, Config config) {
        if (this.logging) {
            this.logger.info("performing DELETE at /{}", (Object)container);
        }
    }

    @Override
    public void deleteObject(String container, String object, Config config) {
        if (this.logging) {
            this.logger.info("performing DELETE at /{}/{}", (Object)container, (Object)object);
        }
    }

    protected void createMetadata(String container, String object, Map<String, String> map, Config config) {
        if (this.logging) {
            this.logger.info("performing POST at /{}/{}", (Object)container, (Object)object);
        }
    }

    protected Map<String, String> getMetadata(String container, String object, Config config) {
        if (this.logging) {
            this.logger.info("performing HEAD at /{}/{}", (Object)container, (Object)object);
        }
        return Collections.emptyMap();
    }

    @Override
    public void setAuthFlag(Boolean auth) {
        this.authFlag = auth;
    }

    @Override
    public Boolean isAuthValid() {
        return this.authFlag;
    }
}

