/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.context;

import java.util.HashMap;
import java.util.Map;

public class Context {
    private Map<String, Object> params = new HashMap<String, Object>();

    public void put(String key, Object val) {
        this.params.put(key, val);
    }

    public Object get(String key) {
        return this.get(key, null);
    }

    public Object get(String key, Object defVal) {
        Object val = this.params.get(key);
        return val == null ? defVal : val;
    }

    public String getStr(String key) {
        return this.getStr(key, null);
    }

    public String getStr(String key, String defVal) {
        Object val = this.params.get(key);
        return val == null ? defVal : val.toString();
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defVal) {
        Object val = this.params.get(key);
        if (val == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(val.toString());
        }
        catch (Exception exception) {
            return defVal;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defVal) {
        Object val = this.params.get(key);
        if (val == null) {
            return defVal;
        }
        try {
            return Long.parseLong(val.toString());
        }
        catch (Exception exception) {
            return defVal;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defVal) {
        Object val = this.params.get(key);
        if (val == null) {
            return defVal;
        }
        try {
            return Double.parseDouble(val.toString());
        }
        catch (Exception exception) {
            return defVal;
        }
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defVal) {
        Object val = this.params.get(key);
        if (val == null) {
            return defVal;
        }
        return Boolean.parseBoolean(val.toString());
    }

    public String toString() {
        return this.params.toString();
    }
}

