/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.tasklet;

import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.controller.model.DriverContext;
import com.intel.cosbench.controller.tasklet.Tasklet;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.protocol.TriggerResponse;
import com.intel.cosbench.service.UnexpectedException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

abstract class TriggerHttpTasklet
implements Tasklet {
    private transient HttpClient httpClient;
    private transient ObjectMapper mapper;
    protected DriverContext driver;
    protected String trigger = null;
    protected boolean isEnable;
    protected String scriptName = null;
    protected String wsId = null;
    Class<TriggerResponse> clazz = TriggerResponse.class;
    private static final int TIMEOUT = 300000;
    protected static final Logger LOGGER = LogFactory.getSystemLogger();

    protected abstract void execute();

    protected abstract void handleResponse(TriggerResponse var1);

    public TriggerHttpTasklet(DriverContext driver, String trigger, boolean option, String wsId) {
        this.driver = driver;
        this.trigger = trigger;
        this.isEnable = option;
        this.wsId = wsId;
    }

    protected void initObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        DeserializationConfig config = mapper.copyDeserializationConfig();
        config.disable(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setDeserializationConfig(config);
        this.mapper = mapper;
    }

    protected void initHttpClient() {
        HttpClient client;
        this.httpClient = client = HttpClientUtil.createHttpClient((int)300000);
    }

    protected synchronized void closeHttpClient() {
        HttpClient client = this.httpClient;
        HttpClientUtil.disposeHttpClient((HttpClient)client);
    }

    private String issueHttpRequest(String command, String content) {
        String url = String.valueOf(this.driver.getUrl()) + "/i/" + command + ".command";
        HttpClient client = this.httpClient;
        HttpPost request = TriggerHttpTasklet.prepareRequest(content, url);
        String body = null;
        try {
            HttpResponse response = client.execute((HttpUriRequest)request);
            body = TriggerHttpTasklet.fetchResponseBody(response);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            LOGGER.error("fail to POST driver while execute trigger");
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            LOGGER.error("fail to POST driver while execute trigger");
        }
        catch (Exception exception) {
            LOGGER.error("fail to POST driver while execute trigger");
        }
        return body;
    }

    private static HttpPost prepareRequest(String content, String url) {
        HttpPost POST = new HttpPost(url);
        try {
            if (StringUtils.isNotEmpty((String)content)) {
                POST.setEntity((HttpEntity)new StringEntity(content));
            }
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        if (content != null && content.length() > 0) {
            if (!content.startsWith("<?xml")) {
                LOGGER.debug("[ >> ] - {} -> {}", (Object)content, (Object)url);
            } else {
                LOGGER.debug("[ >> ] - [xml-content] -> {}", (Object)url);
            }
        } else {
            LOGGER.debug("[ >> ] - [empty-body] -> {}", (Object)url);
        }
        return POST;
    }

    private static String fetchResponseBody(HttpResponse response) throws IOException {
        String body = null;
        HttpEntity entity = response.getEntity();
        StatusLine status = response.getStatusLine();
        try {
            body = EntityUtils.toString((HttpEntity)entity);
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
        if (body.length() < 2048) {
            LOGGER.debug("[ << ] - {} {}", (Object)status, (Object)body);
        } else {
            LOGGER.debug("[ << ] - {} [body-omitted]", (Object)status);
        }
        return body;
    }

    protected void issueCommand(String command, String content) {
        TriggerResponse response = null;
        String body = this.issueHttpRequest(command, content);
        if (body == null) {
            LOGGER.error("TriggerResponse body is null");
            return;
        }
        try {
            response = (TriggerResponse)this.mapper.readValue(body, this.clazz);
        }
        catch (Exception e) {
            LOGGER.error("can not parse TriggerResponse body", (Throwable)e);
            return;
        }
        if (!response.isSucc()) {
            String msg = "driver report error: HTTP {} - {}";
            LOGGER.error(msg, (Object)response.getCode(), (Object)response.getError());
            return;
        }
        this.handleResponse(response);
    }

    @Override
    public Tasklet call() {
        try {
            this.execute();
        }
        catch (Exception e) {
            LOGGER.error("unexpected exception of trigger", (Throwable)e);
        }
        return this;
    }
}

