/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.tasklet;

import com.intel.cosbench.controller.model.DriverContext;
import com.intel.cosbench.controller.tasklet.TriggerHttpTasklet;
import com.intel.cosbench.protocol.TriggerResponse;
import org.apache.commons.lang.StringUtils;

public class Trigger
extends TriggerHttpTasklet {
    public Trigger(DriverContext driver, String trigger, boolean option, String wsId) {
        super(driver, trigger, option, wsId);
    }

    @Override
    public void execute() {
        this.initHttpClient();
        this.initObjectMapper();
        String content = this.getCmdLine();
        if (content == null || content.isEmpty()) {
            return;
        }
        this.issueCommand("trigger", content);
        try {
            this.closeHttpClient();
        }
        catch (Exception e) {
            LOGGER.error("unexpected exception", (Throwable)e);
        }
    }

    private String getCmdLine() {
        this.trigger.replace(" ", "");
        int idxLeft = StringUtils.indexOf((String)this.trigger, (char)'(');
        int idxRight = StringUtils.indexOf((String)this.trigger, (char)')');
        if (idxLeft < 3 || idxRight != this.trigger.length() - 1 || !StringUtils.substring((String)this.trigger, (int)(idxLeft - 3), (int)idxLeft).equals(".sh")) {
            LOGGER.error("trigger format is illegal, it should be like trigger=\"*.sh(arg1, arg2,...)\"");
            return null;
        }
        this.scriptName = StringUtils.left((String)this.trigger, (int)idxLeft);
        String argStr = StringUtils.substring((String)this.trigger, (int)(idxLeft + 1), (int)idxRight);
        return this.isEnable ? "enableTrigger," + this.scriptName + "," + argStr : "killTrigger," + this.driver.getPidMapValue(this.scriptName) + "," + this.scriptName;
    }

    @Override
    protected void handleResponse(TriggerResponse response) {
        this.driver.putPidMap(this.scriptName, response.getPID());
        String log = response.getScriptLog();
        if (log == null || log.isEmpty()) {
            LOGGER.warn("no log for {} on {}", (Object)(String.valueOf(this.isEnable ? "enable " : "kill ") + this.scriptName), (Object)this.driver.getName());
        }
        if (!this.isEnable) {
            String enableLog = this.driver.getLogMapValue(this.wsId);
            this.driver.putLogMap(this.wsId, String.valueOf(enableLog) + log);
            return;
        }
        this.driver.putLogMap(this.wsId, String.valueOf(this.scriptName) + ";" + log);
    }
}

