/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.tasklet;

import com.intel.cosbench.config.Mission;
import com.intel.cosbench.config.MissionWriter;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.config.castor.CastorConfigTools;
import com.intel.cosbench.controller.model.SchedulePlan;
import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.tasklet.AbstractCommandTasklet;
import com.intel.cosbench.model.TaskState;
import com.intel.cosbench.protocol.SubmitResponse;

class Submitter
extends AbstractCommandTasklet<SubmitResponse> {
    public Submitter(TaskContext context) {
        super(context, SubmitResponse.class);
    }

    @Override
    public void execute() {
        MissionWriter writer = CastorConfigTools.getMissionWriter();
        Mission mission = this.createMission();
        this.issueCommand("submit", writer.toXmlString(mission));
        this.context.setState(TaskState.SUBMITTED);
    }

    private Mission createMission() {
        Mission mission = new Mission();
        SchedulePlan plan = this.context.getSchedule();
        Work work = plan.getWork();
        mission.setName(work.getName());
        mission.setWorkers(plan.getWorkers());
        mission.setOffset(plan.getOffset());
        mission.setInterval(work.getInterval());
        mission.setDivision(work.getDivision());
        mission.setRuntime(work.getRuntime());
        mission.setRampup(work.getRampup());
        mission.setRampdown(work.getRampdown());
        mission.setTotalOps(work.getTotalOps());
        mission.setTotalBytes(work.getTotalBytes());
        mission.setTotalWorkers(work.getWorkers());
        mission.setConfig(work.getConfig());
        mission.setAuth(work.getAuth());
        mission.setStorage(work.getStorage());
        mission.setOperations(work.getOperations());
        LOGGER.debug("controller work config is:" + work.getConfig());
        LOGGER.debug("controller mission config is: " + mission.getConfig());
        return mission;
    }

    @Override
    protected void handleResponse(SubmitResponse response) {
        String id = response.getId();
        this.context.setMissionId(id);
    }
}

