/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.tasklet;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.Snapshot;
import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.tasklet.AbstractCommandTasklet;
import com.intel.cosbench.model.TaskState;
import com.intel.cosbench.protocol.QueryResponse;
import com.intel.cosbench.service.CancelledException;
import java.util.Date;

class Querier
extends AbstractCommandTasklet<QueryResponse> {
    public Querier(TaskContext context) {
        super(context, QueryResponse.class);
    }

    @Override
    protected void execute() {
        String id = this.context.getMissionId();
        do {
            this.sleep();
            try {
                this.issueCommand("query", id);
            }
            catch (Exception tle) {
                LOGGER.warn("some unexpected exception occurs when ping drivers, but it's ignorable.", (Throwable)tle);
            }
        } while (!this.context.getState().equals((Object)TaskState.FINISHED));
    }

    private void sleep() {
        long seconds = this.context.getInterval();
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new CancelledException();
        }
    }

    @Override
    protected void handleResponse(QueryResponse response) {
        if (response == null) {
            LOGGER.warn("no response gets from driver");
            return;
        }
        if (!response.isRunning()) {
            this.context.setState(TaskState.FINISHED);
        }
        Date time = response.getTime();
        Report report = new Report();
        for (Metrics metrics : response.getReport()) {
            report.addMetrics(metrics);
        }
        Snapshot snapshot = new Snapshot(report, time);
        snapshot.setVersion(response.getVersion());
        snapshot.setMinVersion(response.getMinVersion());
        snapshot.setMaxVersion(response.getMaxVersion());
        this.context.setSnapshot(snapshot);
    }
}

