/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.tasklet;

import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.tasklet.AbstractCommandTasklet;
import com.intel.cosbench.model.DriverInfo;
import com.intel.cosbench.model.TaskState;
import com.intel.cosbench.protocol.PingResponse;
import org.apache.commons.lang.StringUtils;

class Bootor
extends AbstractCommandTasklet<PingResponse> {
    public Bootor(TaskContext context) {
        super(context, PingResponse.class);
    }

    @Override
    public void execute() {
        this.initHttpClient();
        this.initObjectMapper();
        this.issueCommand("ping");
        this.context.setState(TaskState.BOOTED);
    }

    @Override
    protected void handleResponse(PingResponse response) {
        long driverTime = 0L;
        DriverInfo driver = this.getDriver();
        try {
            driverTime = Long.parseLong(response.getTimeStamp());
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.debug("time stamp of driver {} can not be formated", (Object)driver.getName());
        }
        this.timeDrift = System.currentTimeMillis() - driverTime;
        if (!StringUtils.equals((String)response.getName(), (String)driver.getName())) {
            String msg = "expetect driver name {} dose not match the real name {}";
            LOGGER.debug(msg, (Object)driver.getName(), (Object)response.getName());
        }
    }
}

