/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.tasklet;

import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.tasklet.Tasklet;
import com.intel.cosbench.controller.tasklet.TaskletException;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.DriverInfo;
import com.intel.cosbench.model.TaskState;
import com.intel.cosbench.service.CancelledException;

abstract class AbstractTasklet
implements Tasklet {
    protected static final Logger LOGGER = LogFactory.getSystemLogger();
    protected TaskContext context;

    protected abstract void execute();

    public AbstractTasklet(TaskContext context) {
        this.context = context;
    }

    protected DriverInfo getDriver() {
        return this.context.getSchedule().getDriver();
    }

    @Override
    public Tasklet call() {
        String id = this.context.getId();
        try {
            this.execute();
            LOGGER.debug("tasklet {} exits normally", (Object)id);
        }
        catch (CancelledException cancelledException) {
            this.context.setState(TaskState.INTERRUPTED);
            LOGGER.debug("tasklet {} has been interrupted", (Object)id);
        }
        catch (TaskletException taskletException) {
            this.context.setState(TaskState.ERROR);
            LOGGER.debug("tasklet {} is going to be terminated", (Object)id);
        }
        catch (Exception e) {
            this.context.setState(TaskState.ERROR);
            LOGGER.error("unexpected exception", (Throwable)e);
            LOGGER.debug("tasklet {} is going to be terminated", (Object)id);
        }
        return this;
    }
}

