/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.tasklet;

import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.tasklet.AbstractTasklet;
import com.intel.cosbench.controller.tasklet.TaskletException;
import com.intel.cosbench.service.CancelledException;
import com.intel.cosbench.service.UnexpectedException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

abstract class AbstractHttpTasklet
extends AbstractTasklet {
    private static final int TIMEOUT = 300000;

    public AbstractHttpTasklet(TaskContext context) {
        super(context);
    }

    protected void initHttpClient() {
        HttpClient client = HttpClientUtil.createHttpClient((int)300000);
        this.context.setHttpClient(client);
    }

    protected synchronized void closeHttpClient() {
        HttpClient client = this.context.getHttpClient();
        HttpClientUtil.disposeHttpClient((HttpClient)client);
    }

    protected String issueHttpRequest(String command, String content) {
        String url = String.valueOf(this.getDriver().getUrl()) + "/i/" + command + ".command";
        HttpClient client = this.context.getHttpClient();
        HttpPost request = AbstractHttpTasklet.prepareRequest(content, url);
        String body = null;
        HttpResponse response = null;
        try {
            try {
                response = client.execute((HttpUriRequest)request);
            }
            catch (SocketException se) {
                LOGGER.error("fail to POST driver with socket connection error, will give up the task", (Throwable)se);
                throw new CancelledException();
            }
            catch (SocketTimeoutException ste) {
                LOGGER.error("fail to POST driver with url=" + url, (Throwable)ste);
                throw new TaskletException();
            }
            catch (ConnectTimeoutException cte) {
                LOGGER.error("fail to POST driver with url=" + url, (Throwable)cte);
                throw new TaskletException();
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new CancelledException();
            }
            catch (Exception e) {
                LOGGER.error("fail to POST driver with url=" + url, (Throwable)e);
                throw new TaskletException();
            }
        }
        finally {
            if (response != null) {
                try {
                    body = AbstractHttpTasklet.fetchResponseBody(response);
                }
                catch (IOException ioe) {
                    LOGGER.error("fail to fetch response body", (Throwable)ioe);
                }
            }
        }
        return body;
    }

    private static HttpPost prepareRequest(String content, String url) {
        HttpPost POST = new HttpPost(url);
        try {
            if (StringUtils.isNotEmpty((String)content)) {
                POST.setEntity((HttpEntity)new StringEntity(content));
            }
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        if (content != null && content.length() > 0) {
            if (!content.startsWith("<?xml")) {
                LOGGER.debug("[ >> ] - {} -> {}", (Object)content, (Object)url);
            } else {
                LOGGER.debug("[ >> ] - [xml-content] -> {}", (Object)url);
            }
        } else {
            LOGGER.debug("[ >> ] - [empty-body] -> {}", (Object)url);
        }
        return POST;
    }

    private static String fetchResponseBody(HttpResponse response) throws IOException {
        String body = null;
        HttpEntity entity = response.getEntity();
        StatusLine status = response.getStatusLine();
        try {
            body = EntityUtils.toString((HttpEntity)entity);
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
        if (body.length() < 2048) {
            LOGGER.debug("[ << ] - {} {}", (Object)status, (Object)body);
        } else {
            LOGGER.debug("[ << ] - {} [body-omitted]", (Object)status);
        }
        return body;
    }
}

