/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.tasklet;

import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.tasklet.AbstractHttpTasklet;
import com.intel.cosbench.controller.tasklet.TaskletException;
import com.intel.cosbench.protocol.Response;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

abstract class AbstractCommandTasklet<T extends Response>
extends AbstractHttpTasklet {
    private Class<T> clazz;
    protected long timeDrift = 0L;
    private static int tolerableTimeDrift = 300;

    protected abstract void handleResponse(T var1);

    public AbstractCommandTasklet(TaskContext context, Class<T> clazz) {
        super(context);
        this.clazz = clazz;
    }

    protected void initObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        DeserializationConfig config = mapper.copyDeserializationConfig();
        config.disable(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setDeserializationConfig(config);
        this.context.setMapper(mapper);
    }

    protected void issueCommand(String command) {
        int count = 3;
        long timeStamp = System.currentTimeMillis();
        while (--count >= 0) {
            this.issueCommand(command, String.valueOf(timeStamp));
            if (Math.abs(this.timeDrift) < (long)tolerableTimeDrift) break;
            timeStamp = System.currentTimeMillis() + this.timeDrift / 2L;
        }
        LOGGER.info("time drift between controller and driver-{} is {} mSec", (Object)this.getDriver().getName(), (Object)this.timeDrift);
        if (count < 0) {
            LOGGER.warn("time drift is still longer than tolerable time drift {} mSec after 3 times of synchronization", (Object)tolerableTimeDrift);
        }
    }

    protected void issueCommand(String command, String content) {
        Response response = null;
        String body = this.issueHttpRequest(command, content);
        try {
            response = (Response)this.context.getMapper().readValue(body, this.clazz);
        }
        catch (Exception e) {
            LOGGER.error("cannot parse response body", (Throwable)e);
            throw new TaskletException();
        }
        if (!response.isSucc()) {
            String msg = "driver report error: HTTP {} - {}";
            LOGGER.error(msg, (Object)response.getCode(), (Object)response.getError());
            throw new TaskletException();
        }
        this.handleResponse(response);
    }
}

