/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.tasklet;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.tasklet.AbstractCommandTasklet;
import com.intel.cosbench.model.TaskState;
import com.intel.cosbench.protocol.AbortResponse;

class Aborter
extends AbstractCommandTasklet<AbortResponse> {
    public Aborter(TaskContext context) {
        super(context, AbortResponse.class);
    }

    @Override
    protected void execute() {
        this.executeAbort();
        if (!this.context.getState().equals((Object)TaskState.ERROR)) {
            this.context.setState(TaskState.ABORTED);
        } else {
            this.context.setState(TaskState.TERMINATED);
        }
    }

    private void executeAbort() {
        try {
            String id = this.context.getMissionId();
            try {
                try {
                    this.issueCommand("abort", id);
                }
                catch (Exception e) {
                    LOGGER.error("fail to abort driver", (Throwable)e);
                    this.closeHttpClient();
                }
            }
            finally {
                this.closeHttpClient();
            }
        }
        catch (Exception e) {
            LOGGER.error("unexpected exception", (Throwable)e);
        }
    }

    @Override
    protected void handleResponse(AbortResponse response) {
        Report report = new Report();
        for (Metrics metrics : response.getReport()) {
            report.addMetrics(metrics);
        }
        this.context.setReport(report);
        this.context.setLog(response.getDriverLog());
    }
}

