/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.service;

import com.intel.cosbench.config.Operation;
import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.config.WorkloadResolver;
import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.config.castor.CastorConfigTools;
import com.intel.cosbench.controller.model.ControllerContext;
import com.intel.cosbench.controller.model.StageContext;
import com.intel.cosbench.controller.model.StageRegistry;
import com.intel.cosbench.controller.model.WorkloadContext;
import com.intel.cosbench.controller.service.StageCallable;
import com.intel.cosbench.controller.service.StageChecker;
import com.intel.cosbench.controller.service.StageRunner;
import com.intel.cosbench.controller.service.TriggerRunner;
import com.intel.cosbench.controller.service.WorkloadException;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.StageState;
import com.intel.cosbench.model.WorkloadState;
import com.intel.cosbench.service.CancelledException;
import com.intel.cosbench.service.IllegalStateException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class WorkloadProcessor {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private WorkloadContext workloadContext;
    private ControllerContext controllerContext;
    private ExecutorService executor;
    private List<StageContext> queue;

    public WorkloadContext getWorkloadContext() {
        return this.workloadContext;
    }

    public void setWorkloadContext(WorkloadContext workloadContext) {
        this.workloadContext = workloadContext;
        this.workloadContext.setDriverRegistry(this.controllerContext.getDriverRegistry());
    }

    public void setControllerContext(ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
    }

    public void init() {
        this.resolveWorklaod();
        this.createStages();
        this.createExecutor();
    }

    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    private void resolveWorklaod() {
        XmlConfig config = this.workloadContext.getConfig();
        WorkloadResolver resolver = CastorConfigTools.getWorkloadResolver();
        this.workloadContext.setWorkload(resolver.toWorkload(config));
    }

    private void createStages() {
        StageRegistry registry = new StageRegistry();
        int index = 1;
        for (Stage stage : this.workloadContext.getWorkload().getWorkflow()) {
            String id = "s" + index++ + "-" + stage.getName();
            registry.addStage(WorkloadProcessor.createStageContext(id, stage));
        }
        this.workloadContext.setStageRegistry(registry);
    }

    private static StageContext createStageContext(String id, Stage stage) {
        WorkloadProcessor.initStageOpId(stage);
        StageContext context = new StageContext();
        context.setId(id);
        context.setStage(stage);
        context.setState(StageState.WAITING);
        return context;
    }

    private static void initStageOpId(Stage stage) {
        int index = 0;
        for (Work work : stage.getWorks()) {
            for (Operation op : work.getOperations()) {
                if (!"none".equals(op.getId())) continue;
                op.setId("op" + String.valueOf(++index));
            }
        }
    }

    private void createExecutor() {
        this.executor = Executors.newFixedThreadPool(2);
        StageRegistry registry = this.workloadContext.getStageRegistry();
        this.queue = new LinkedList<StageContext>(registry.getAllItems());
    }

    public void process() {
        if (!this.workloadContext.getState().equals((Object)WorkloadState.QUEUING)) {
            throw new IllegalStateException("workload should be in the state of queuing but " + this.workloadContext.getState().name());
        }
        String id = this.workloadContext.getId();
        LOGGER.info("begin to process workload {}", (Object)id);
        try {
            this.processWorkload();
        }
        catch (CancelledException cancelledException) {
            this.cancelWorkload();
            return;
        }
        catch (WorkloadException workloadException) {
            this.terminateWorkload();
            return;
        }
        catch (InterruptedException interruptedException) {
            this.terminateWorkload();
            return;
        }
        catch (Exception e) {
            LOGGER.error("unexpected exception", (Throwable)e);
            this.terminateWorkload();
            return;
        }
        this.workloadContext.logErrorStatistics(LOGGER);
        LOGGER.info("sucessfully processed workload {}", (Object)id);
    }

    private void processWorkload() throws InterruptedException {
        this.workloadContext.setState(WorkloadState.PROCESSING);
        this.workloadContext.setStartDate(new Date());
        Iterator<StageContext> iter = this.queue.iterator();
        String trigger = this.workloadContext.getWorkload().getTrigger();
        this.executeTrigger(trigger, true, this.workloadContext.getId());
        while (iter.hasNext()) {
            StageContext stageContext = iter.next();
            iter.remove();
            this.runStage(stageContext);
        }
        this.executeTrigger(trigger, false, this.workloadContext.getId());
        this.workloadContext.setStopDate(new Date());
        this.workloadContext.setCurrentStage(null);
        this.workloadContext.mergeErrorStatistics();
        for (StageContext stageContext : this.workloadContext.getStageRegistry().getAllItems()) {
            if (!stageContext.getState().equals((Object)StageState.FAILED)) continue;
            this.workloadContext.setState(WorkloadState.FAILED);
            return;
        }
        this.workloadContext.setState(WorkloadState.FINISHED);
    }

    private static String millisToHMS(long millis) {
        long hrs = TimeUnit.MILLISECONDS.toHours(millis) % 24L;
        long min = TimeUnit.MILLISECONDS.toMinutes(millis) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(millis) % 60L;
        return String.valueOf(hrs) + ":" + min + "::" + sec;
    }

    private void runStage(StageContext stageContext) throws InterruptedException {
        String id = stageContext.getId();
        int closuredelay = stageContext.getStage().getClosuredelay();
        String stageName = stageContext.getStage().getName();
        LOGGER.info("begin to run stage {}", (Object)id);
        LOGGER.info("============================================");
        LOGGER.info("START WORK: {}", (Object)stageName);
        long startStamp = System.currentTimeMillis();
        this.workloadContext.setCurrentStage(stageContext);
        if (stageName.equals("delay") && closuredelay > 0) {
            this.executeDelay(stageContext, closuredelay);
        } else {
            this.executeStage(stageContext);
            long elapsedTime = System.currentTimeMillis() - startStamp;
            LOGGER.info("END WORK:   {}, Time elapsed: {}", (Object)stageName, (Object)WorkloadProcessor.millisToHMS(elapsedTime));
            LOGGER.info("============================================");
            if (closuredelay > 0) {
                this.executeDelay(stageContext, closuredelay);
            }
        }
        LOGGER.info("successfully ran stage {}", (Object)id);
    }

    private void executeDelay(StageContext stageContext, int closuredelay) throws InterruptedException {
        LOGGER.info("sleeping for " + closuredelay + " seconds...");
        stageContext.setState(StageState.SLEEPING);
        Thread.sleep(closuredelay * 1000);
        LOGGER.info("sleep complete.");
        stageContext.setState(StageState.COMPLETED);
    }

    private void executeStage(StageContext stageContext) {
        StageRunner runner = this.createStageRunner(stageContext);
        StageChecker checker = this.createStageChecker(stageContext);
        StageCallable[] callables = new StageCallable[]{runner, checker};
        String wsId = String.valueOf(this.workloadContext.getId()) + stageContext.getId();
        String trigger = stageContext.getStage().getTrigger();
        this.executeTrigger(trigger, true, wsId);
        try {
            this.executor.invokeAll(Arrays.asList(callables));
        }
        catch (InterruptedException interruptedException) {
            this.executeTrigger(trigger, false, wsId);
            throw new CancelledException();
        }
        runner.dispose();
        this.executeTrigger(trigger, false, wsId);
        if (!stageContext.getState().equals((Object)StageState.TERMINATED)) {
            return;
        }
        String id = stageContext.getId();
        LOGGER.error("detected stage {} encountered error", (Object)id);
        throw new WorkloadException();
    }

    private StageRunner createStageRunner(StageContext stageContext) {
        StageRunner runner = new StageRunner();
        runner.setStageContext(stageContext);
        runner.setControllerContext(this.controllerContext);
        runner.init();
        return runner;
    }

    private StageChecker createStageChecker(StageContext stageContext) {
        StageChecker checker = new StageChecker();
        checker.setStageContext(stageContext);
        return checker;
    }

    private void terminateWorkload() {
        String id = this.workloadContext.getId();
        LOGGER.info("begin to terminate workload {}", (Object)id);
        for (StageContext stageContext : this.queue) {
            stageContext.setState(StageState.ABORTED);
        }
        this.executeTrigger(this.workloadContext.getWorkload().getTrigger(), false, this.workloadContext.getId());
        this.workloadContext.setStopDate(new Date());
        this.workloadContext.setState(WorkloadState.TERMINATED);
        LOGGER.info("successfully terminated workload {}", (Object)id);
    }

    private void executeTrigger(String trigger, boolean isEnable, String wsId) {
        if (trigger == null || trigger.isEmpty()) {
            return;
        }
        TriggerRunner runner = new TriggerRunner(this.workloadContext.getDriverRegistry());
        runner.runTrigger(isEnable, trigger, wsId);
    }

    public void cancel() {
        String id = this.workloadContext.getId();
        Future<?> future = this.workloadContext.getFuture();
        if (future != null) {
            if (future.isCancelled()) {
                return;
            }
            if (future.cancel(true)) {
                if (this.workloadContext.getState().equals((Object)WorkloadState.QUEUING)) {
                    for (StageContext stageContext : this.queue) {
                        stageContext.setState(StageState.CANCELLED);
                    }
                    this.workloadContext.setStopDate(new Date());
                    this.workloadContext.setState(WorkloadState.CANCELLED);
                    LOGGER.info("successfully cancelled workload {}", (Object)id);
                    return;
                }
                return;
            }
        }
        if (WorkloadState.isStopped((WorkloadState)this.workloadContext.getState())) {
            LOGGER.warn("workload {} not aborted as it is already stopped", (Object)id);
            return;
        }
        this.workloadContext.setStopDate(new Date());
        this.workloadContext.setState(WorkloadState.CANCELLED);
        LOGGER.info("successfully cancelled workload {}", (Object)id);
    }

    private void cancelWorkload() {
        String id = this.workloadContext.getId();
        LOGGER.info("begin to cancel workload {}", (Object)id);
        this.executor.shutdown();
        if (Thread.interrupted()) {
            LOGGER.warn("get cancelled when canceling workload {}", (Object)id);
        }
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS) && !this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
            if (!(this.awaitTermination(5) || this.awaitTermination(10) || this.awaitTermination(30))) {
                LOGGER.warn("get cancelled when canceling workload {}", (Object)id);
            }
        }
        catch (InterruptedException interruptedException) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        if (!this.executor.isTerminated()) {
            LOGGER.warn("fail to cancel current stage for workload {}", (Object)id);
        }
        for (StageContext stageContext : this.queue) {
            stageContext.setState(StageState.CANCELLED);
        }
        this.executeTrigger(this.workloadContext.getWorkload().getTrigger(), false, this.workloadContext.getId());
        this.workloadContext.setStopDate(new Date());
        this.workloadContext.setState(WorkloadState.CANCELLED);
        LOGGER.info("successfully cancelled workload {}", (Object)id);
    }

    private boolean awaitTermination(int seconds) {
        try {
            if (!this.executor.isTerminated()) {
                LOGGER.info("wait {} seconds for workload to cancel ...", (Object)seconds);
                this.executor.awaitTermination(seconds, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.debug("get cancelled when canceling workload");
        }
        return this.executor.isTerminated();
    }
}

