/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.service;

import com.intel.cosbench.controller.model.DriverRegistry;
import com.intel.cosbench.controller.tasklet.Tasklet;
import com.intel.cosbench.controller.tasklet.Tasklets;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TriggerRunner {
    DriverRegistry registry;
    private ExecutorService executor;
    private static final Logger LOGGER = LogFactory.getSystemLogger();

    public TriggerRunner(DriverRegistry registry) {
        this.registry = registry;
        this.createExecutor();
    }

    public void runTrigger(boolean option, String trigger, String wsId) {
        List<Tasklet> tasklets = Tasklets.newTriggers(trigger, this.registry, option, wsId);
        this.executeTasklets(tasklets, option);
        this.dispose();
    }

    private void createExecutor() {
        int taskCount = this.registry.getSize();
        this.executor = Executors.newFixedThreadPool(taskCount);
    }

    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    private void executeTasklets(List<Tasklet> tasklets, boolean option) {
        int num = tasklets.size();
        LOGGER.debug("begin to execute {}-trigger tasklets, {} in total", (Object)(option ? "enable" : "kill"), (Object)num);
        try {
            this.executor.invokeAll(tasklets);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.debug("{}-trigger tasklets have interrupted", (Object)(option ? "enable" : "kill"), (Object)num);
            return;
        }
        LOGGER.debug("all {} trigger tasklets have finished execution", (Object)num);
    }
}

