/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.service;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.controller.model.ControllerContext;
import com.intel.cosbench.controller.model.DriverRegistry;
import com.intel.cosbench.controller.model.SchedulePlan;
import com.intel.cosbench.controller.model.StageContext;
import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.model.TaskRegistry;
import com.intel.cosbench.controller.schedule.Schedulers;
import com.intel.cosbench.controller.schedule.WorkScheduler;
import com.intel.cosbench.controller.service.StageCallable;
import com.intel.cosbench.controller.service.StageException;
import com.intel.cosbench.controller.tasklet.Tasklet;
import com.intel.cosbench.controller.tasklet.Tasklets;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.StageState;
import com.intel.cosbench.model.TaskState;
import com.intel.cosbench.service.CancelledException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class StageRunner
implements StageCallable {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private StageContext stageContext;
    private ControllerContext controllerContext;
    private ExecutorService executor;

    public StageContext getStageContext() {
        return this.stageContext;
    }

    public void setStageContext(StageContext stageContext) {
        this.stageContext = stageContext;
    }

    public void setControllerContext(ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
    }

    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    public void init() {
        this.scheduleWorks();
        this.createTasks();
        this.createExecutor();
    }

    private void scheduleWorks() {
        WorkScheduler scheduler = null;
        Stage stage = this.stageContext.getStage();
        DriverRegistry registry = this.controllerContext.getDriverRegistry();
        scheduler = Schedulers.defaultScheduler(stage, registry);
        this.stageContext.setScheduleRegistry(scheduler.schedule());
    }

    private void createTasks() {
        TaskRegistry registry = new TaskRegistry();
        int index = 1;
        Iterator iterator = this.stageContext.getScheduleRegistry().iterator();
        while (iterator.hasNext()) {
            SchedulePlan plan = (SchedulePlan)iterator.next();
            String id = "t" + index++;
            registry.addTask(StageRunner.createTaskContext(id, plan));
        }
        this.stageContext.setTaskRegistry(registry);
    }

    private static TaskContext createTaskContext(String id, SchedulePlan plan) {
        TaskContext context = new TaskContext();
        context.setId(id);
        context.setSchedule(plan);
        context.setState(TaskState.CREATED);
        return context;
    }

    private void createExecutor() {
        int taskCount = this.stageContext.getTaskCount();
        this.executor = Executors.newFixedThreadPool(taskCount);
    }

    @Override
    public StageRunner call() {
        try {
            this.runStage();
        }
        catch (CancelledException cancelledException) {
            this.cancelStage();
        }
        catch (StageException stageException) {
            this.terminateStage();
        }
        catch (Exception e) {
            LOGGER.error("unexpected exception", (Throwable)e);
            this.terminateStage();
        }
        return this;
    }

    private void runStage() {
        this.bootTasks();
        if (Thread.interrupted()) {
            throw new CancelledException();
        }
        this.submitTasks();
        if (Thread.interrupted()) {
            throw new CancelledException();
        }
        this.authTasks();
        if (Thread.interrupted()) {
            throw new CancelledException();
        }
        this.launchTasks();
        if (Thread.interrupted()) {
            throw new CancelledException();
        }
        this.queryTasks();
        if (Thread.interrupted()) {
            throw new CancelledException();
        }
        this.closeTasks();
        TaskRegistry tasks = this.stageContext.getTaskRegistry();
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            TaskContext task = (TaskContext)iterator.next();
            if (!task.getState().equals((Object)TaskState.FAILED)) continue;
            this.stageContext.setState(StageState.FAILED);
            return;
        }
        if (!this.reachAFRGoal()) {
            this.stageContext.setState(StageState.FAILED);
            return;
        }
        this.stageContext.setState(StageState.COMPLETED);
    }

    private boolean reachAFRGoal() {
        String id = this.stageContext.getId();
        boolean bool = true;
        this.stageContext.setReport(this.stageContext.mergeReport());
        for (Work work : this.stageContext.getStage().getWorks()) {
            List operationIDs = work.getOperationIDs();
            long sumSampleCount = 0L;
            long sumTotalSampleCount = 0L;
            Metrics[] metricsArray = this.stageContext.getReport().getAllMetrics();
            int n = metricsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Metrics metric = metricsArray[n2];
                if (operationIDs.contains(metric.getOpId())) {
                    sumSampleCount += (long)(metric.getSampleCount() > 0 ? metric.getSampleCount() : 0);
                    sumTotalSampleCount += (long)(metric.getTotalSampleCount() > 0 ? metric.getTotalSampleCount() : 0);
                }
                ++n2;
            }
            LOGGER.info("acceptable failure ratio of work {} = {}", (Object)(String.valueOf(id) + "-" + work.getName()), (Object)((double)work.getAfr() / 1000000.0));
            LOGGER.info("real failure ratio of work {} = {}", (Object)(String.valueOf(id) + "-" + work.getName()), sumTotalSampleCount > 0L ? Double.valueOf((double)(sumTotalSampleCount - sumSampleCount) / (double)sumTotalSampleCount) : "N/A");
            if (sumTotalSampleCount - sumSampleCount > sumTotalSampleCount * (long)work.getAfr() / 1000000L) {
                LOGGER.info("fail to reach the goal of acceptable failure ratio in stage {} - work {}", (Object)id, (Object)work.getName());
                bool = false;
                continue;
            }
            LOGGER.info("successfully reach the goal of acceptable failure ratio in stage {} - work {}", (Object)id, (Object)work.getName());
        }
        return bool;
    }

    private void bootTasks() {
        String id = this.stageContext.getId();
        this.stageContext.setState(StageState.BOOTING);
        TaskRegistry tasks = this.stageContext.getTaskRegistry();
        List<Tasklet> tasklets = Tasklets.newBooters(tasks);
        this.executeTasklets(tasklets);
        LOGGER.info("successfully booted all tasks in stage {}", (Object)id);
    }

    private void submitTasks() {
        String id = this.stageContext.getId();
        this.stageContext.setState(StageState.SUBMITTING);
        TaskRegistry tasks = this.stageContext.getTaskRegistry();
        List<Tasklet> tasklets = Tasklets.newSubmitters(tasks);
        this.executeTasklets(tasklets);
        LOGGER.info("successfully submitted all tasks in stage {}", (Object)id);
    }

    private void authTasks() {
        String id = this.stageContext.getId();
        this.stageContext.setState(StageState.AUTHING);
        TaskRegistry tasks = this.stageContext.getTaskRegistry();
        List<Tasklet> tasklets = Tasklets.newAuthenticators(tasks);
        this.executeTasklets(tasklets);
        LOGGER.info("successfully authenticated all tasks in stage {}", (Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTasks() {
        String id = this.stageContext.getId();
        this.stageContext.setState(StageState.LAUNCHING);
        TaskRegistry tasks = this.stageContext.getTaskRegistry();
        List<Tasklet> tasklets = Tasklets.newLaunchers(tasks);
        this.executeTasklets(tasklets);
        this.updateStageInfo();
        StageContext stageContext = this.stageContext;
        synchronized (stageContext) {
            this.stageContext.notify();
        }
        LOGGER.info("successfully launched all tasks in stage {}", (Object)id);
    }

    private void updateStageInfo() {
        int interval = Integer.MAX_VALUE;
        Iterator iterator = this.stageContext.getTaskRegistry().iterator();
        while (iterator.hasNext()) {
            TaskContext taskContext = (TaskContext)iterator.next();
            int i = taskContext.getInterval();
            int n = interval = i < interval ? i : interval;
        }
        this.stageContext.setInterval(interval);
        this.stageContext.setState(StageState.RUNNING);
    }

    private void queryTasks() {
        String id = this.stageContext.getId();
        TaskRegistry tasks = this.stageContext.getTaskRegistry();
        List<Tasklet> tasklets = Tasklets.newQueriers(tasks);
        this.executeTasklets(tasklets);
        LOGGER.info("successfully queried all tasks in stage {}", (Object)id);
    }

    private void closeTasks() {
        String id = this.stageContext.getId();
        this.stageContext.setState(StageState.CLOSING);
        TaskRegistry tasks = this.stageContext.getTaskRegistry();
        List<Tasklet> tasklets = Tasklets.newClosers(tasks);
        this.executeTasklets(tasklets);
        LOGGER.info("successfully closed all tasks in stage {}", (Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateStage() {
        String id = this.stageContext.getId();
        LOGGER.info("begin to terminate stage {}", (Object)id);
        TaskRegistry tasks = this.stageContext.getTaskRegistry();
        List<Tasklet> tasklets = Tasklets.newAborters(tasks);
        this.executeTasklets(tasklets);
        this.stageContext.setState(StageState.TERMINATED);
        StageContext stageContext = this.stageContext;
        synchronized (stageContext) {
            this.stageContext.notify();
        }
        LOGGER.info("stage {} has been terminated", (Object)id);
    }

    private void cancelStage() {
        String id = this.stageContext.getId();
        LOGGER.info("begin to cancel stage {}", (Object)id);
        this.executor.shutdownNow();
        if (Thread.interrupted()) {
            LOGGER.warn("get cancelled when canceling stage");
        }
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("get cancelled when canceling stage");
        }
        if (!this.executor.isTerminated()) {
            LOGGER.warn("fail to cancel current tasklets for stage {}", (Object)id);
        }
        int taskCount = this.stageContext.getTaskCount();
        this.executor = Executors.newFixedThreadPool(taskCount);
        TaskRegistry tasks = this.stageContext.getTaskRegistry();
        List<Tasklet> tasklets = Tasklets.newAborters(tasks);
        this.executeTasklets(tasklets);
        this.stageContext.setState(StageState.CANCELLED);
        this.executor.shutdownNow();
        LOGGER.info("stage {} has been cancelled", (Object)id);
    }

    private void executeTasklets(List<Tasklet> tasklets) {
        int num = tasklets.size();
        LOGGER.debug("begin to execute tasklets, {} in total", (Object)num);
        try {
            this.executor.invokeAll(tasklets);
        }
        catch (InterruptedException interruptedException) {
            throw new CancelledException();
        }
        LOGGER.debug("all {} tasklets have finished execution", (Object)num);
        ArrayList<String> errIds = new ArrayList<String>();
        Iterator iterator = this.stageContext.getTaskRegistry().iterator();
        while (iterator.hasNext()) {
            TaskContext task = (TaskContext)iterator.next();
            if (!task.getState().equals((Object)TaskState.ERROR) && !task.getState().equals((Object)TaskState.INTERRUPTED)) continue;
            errIds.add(task.getId());
        }
        if (errIds.isEmpty()) {
            return;
        }
        LOGGER.error("detected tasks {} have encountered errors", errIds);
        throw new StageException();
    }
}

