/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.service;

import com.intel.cosbench.controller.model.StageContext;
import com.intel.cosbench.controller.service.StageCallable;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.StageState;
import com.intel.cosbench.service.CancelledException;

public class StageChecker
implements StageCallable {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private StageContext stageContext;

    public void setStageContext(StageContext stageContext) {
        this.stageContext = stageContext;
    }

    @Override
    public StageChecker call() {
        try {
            this.checkStage();
        }
        catch (CancelledException cancelledException) {
        }
        catch (Exception e) {
            LOGGER.error("unexpected exception", (Throwable)e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStage() {
        StageContext stageContext = this.stageContext;
        synchronized (stageContext) {
            try {
                if (!StageState.hasLaunched((StageState)this.stageContext.getState())) {
                    this.stageContext.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new CancelledException();
            }
        }
        if (StageState.isStopped((StageState)this.stageContext.getState())) {
            return;
        }
        this.hold();
        do {
            this.sleep();
            this.stageContext.makeSnapshot();
            LOGGER.debug("made a snapshot for stage {}", (Object)this.stageContext.getId());
        } while (!StageState.isStopped((StageState)this.stageContext.getState()));
    }

    private void hold() {
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException interruptedException) {
            throw new CancelledException();
        }
    }

    private void sleep() {
        long seconds = this.stageContext.getInterval();
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new CancelledException();
        }
    }
}

