/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.service;

import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.DriverInfo;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class PingDriverRunner
implements Runnable {
    protected static final Logger LOGGER = LogFactory.getSystemLogger();
    private static final int base_interval = 20;
    private static final int failure_tolerance = 3;
    private static final int ext_interval = 60;
    private static final int delay = 3;
    private DriverInfo[] driverInfos;
    private int driver_count = 0;
    private int[] failures;
    private boolean[] all_alive;

    PingDriverRunner(DriverInfo[] driverInfos) {
        this.driverInfos = driverInfos;
        this.driver_count = driverInfos.length;
        this.failures = new int[this.driver_count];
        this.all_alive = new boolean[this.driver_count];
    }

    public boolean isAlive() {
        boolean[] blArray = this.all_alive;
        int n = this.all_alive.length;
        int n2 = 0;
        while (n2 < n) {
            boolean status = blArray[n2];
            if (!status) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void checkFaultyDrivers() {
        int i = 0;
        while (i < this.driver_count) {
            if (!this.all_alive[i]) {
                LOGGER.error(String.valueOf(this.driverInfos[i].getName()) + " at " + this.driverInfos[i].getUrl());
            }
            ++i;
        }
    }

    @Override
    public void run() {
        while (true) {
            this.pingDrivers(this.driverInfos);
            int interval = 20;
            if (!this.isAlive()) {
                LOGGER.error("below drivers are not alive:");
                this.checkFaultyDrivers();
                interval = 60;
            }
            try {
                LOGGER.info("begin to sleep for " + interval + " seconds.");
                Thread.sleep(interval * 1000);
                LOGGER.info("wake up from sleep.");
                continue;
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("thread sleep is interrupted.");
                continue;
            }
            break;
        }
    }

    private void pingDrivers(DriverInfo[] driverInfos) {
        int i = 0;
        while (i < driverInfos.length) {
            block17: {
                DriverInfo driver = driverInfos[i];
                String ipAddress = this.getIpAddres(driver.getUrl());
                Integer port = this.getDriverPort(driver.getUrl());
                LOGGER.info("Trying to ping driver " + driver.getName() + " at " + driver.getUrl() + " with ip=" + ipAddress + ", port=" + port + "...");
                if (ipAddress == null || ipAddress.isEmpty()) {
                    this.all_alive[i] = false;
                    this.failures[i] = 3;
                    LOGGER.error("the driver ip address shouldn't be empty, the heartbeat is disabled to driver !" + driver.getName());
                    return;
                }
                Socket socket = null;
                try {
                    try {
                        socket = new Socket();
                        socket.connect(new InetSocketAddress(ipAddress, (int)port), 3000);
                        this.all_alive[i] = true;
                        this.failures[i] = 0;
                        LOGGER.info("The driver " + driver.getName() + " at " + driver.getUrl() + " is reachable");
                    }
                    catch (Exception e) {
                        int n = i;
                        this.failures[n] = this.failures[n] + 1;
                        LOGGER.warn("The driver " + driver.getName() + " at " + driver.getUrl() + " is not reachable at the " + this.failures[i] + " time, with error message: " + e.getMessage());
                        if (this.failures[i] >= 3) {
                            this.all_alive[i] = false;
                            LOGGER.warn("The driver " + driver.getName() + " at " + driver.getUrl() + " hits failure tolerance, will extend the heartbeat interval to " + 60 + " seconds");
                        }
                        driver.setAliveState(this.all_alive[i]);
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    driver.setAliveState(this.all_alive[i]);
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                driver.setAliveState(this.all_alive[i]);
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++i;
        }
    }

    private String getIpAddres(String url) {
        int start = url.indexOf(47) + 2;
        int end = url.lastIndexOf(58);
        return end > start ? url.substring(start, end) : null;
    }

    private Integer getDriverPort(String url) {
        int start = url.lastIndexOf(":") + 1;
        int end = url.lastIndexOf("/");
        return end > start ? Integer.valueOf(url.substring(start, end)) : null;
    }
}

