/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.service;

import com.intel.cosbench.config.castor.CastorConfigTools;
import com.intel.cosbench.controller.model.ControllerContext;
import com.intel.cosbench.controller.model.DriverContext;
import com.intel.cosbench.controller.model.DriverRegistry;
import com.intel.cosbench.controller.service.COSBControllerService;
import com.intel.cosbench.service.AbstractServiceFactory;
import com.intel.cosbench.service.ControllerService;
import com.intel.cosbench.service.ControllerServiceFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.lang.SystemUtils;

public class COSBControllerServiceFactory
extends AbstractServiceFactory
implements ControllerServiceFactory {
    private static final String SERVICE_NAME = "controller";
    private static final String CFG_FILE_KEY = "cosbench.controller.config";
    private static final String UNIX_DEFAULT_CFG_FILE = "/etc/cosbench/controller.conf";
    private static final String WIN_DEFAULT_CFG_FILE = "C:\\controller.conf";

    public COSBControllerServiceFactory() {
        CastorConfigTools.getWorkloadResolver();
    }

    protected String getConfigFile() {
        String configFile = System.getProperty(CFG_FILE_KEY);
        if (configFile != null) {
            return configFile;
        }
        if (new File("controller.conf").exists()) {
            return "controller.conf";
        }
        if (new File("conf/controller.conf").exists()) {
            return "conf/controller.conf";
        }
        return SystemUtils.IS_OS_WINDOWS ? WIN_DEFAULT_CFG_FILE : UNIX_DEFAULT_CFG_FILE;
    }

    protected String getServiceName() {
        return SERVICE_NAME;
    }

    public ControllerService getControllerService() {
        COSBControllerService service = new COSBControllerService();
        ControllerContext context = this.getControllerContext();
        service.setContext(context);
        service.init();
        return service;
    }

    private ControllerContext getControllerContext() {
        ControllerContext context = new ControllerContext();
        context.setName(this.loadControllerName());
        context.setUrl(this.loadControllerUrl());
        context.setArchive_dir(this.loadArchiveDir());
        context.setConcurrency(this.loadConcurrency());
        context.setDriverRegistry(this.getDriverRegistry());
        context.setVersion(this.getVersion());
        return context;
    }

    private String getVersion() {
        String str = this.getName("VERSION");
        String str2 = this.getName("BUILD.no");
        return String.valueOf(str) + "." + str2;
    }

    private String getName(String fileName) {
        String str = null;
        File myFile = new File(fileName);
        if (!myFile.exists()) {
            System.err.println("Can't Find " + fileName);
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(myFile));
            str = in.readLine();
            in.close();
        }
        catch (IOException e) {
            e.getStackTrace();
        }
        return str;
    }

    protected String loadLogLevel() {
        return this.config.get("controller.log_level", "INFO");
    }

    protected String loadLogFile() {
        return this.config.get("controller.log_file", "log/system.log");
    }

    private String loadArchiveDir() {
        return this.config.get("controller.archive_dir", "archive");
    }

    private String loadControllerName() {
        return this.config.get("controller.name", "N/A");
    }

    private String loadControllerUrl() {
        return this.config.get("controller.url", "N/A");
    }

    private int loadConcurrency() {
        return this.config.getInt("controller.concurrency", 1);
    }

    private DriverRegistry getDriverRegistry() {
        DriverRegistry registry = new DriverRegistry();
        int drivers = this.config.getInt("controller.drivers");
        int i = 1;
        while (i <= drivers) {
            DriverContext context = this.getDriverContext(i);
            registry.addDriver(context);
            ++i;
        }
        return registry;
    }

    private DriverContext getDriverContext(int index) {
        DriverContext context = new DriverContext();
        context.setName(this.loadDriverName(index));
        context.setUrl(this.loadDriverUrl(index));
        context.setAliveState(false);
        return context;
    }

    private String loadDriverName(int index) {
        return this.config.get("driver" + index + ".name");
    }

    private String loadDriverUrl(int index) {
        return this.config.get("driver" + index + ".url");
    }
}

