/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.service;

import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.controller.archiver.SimpleWorkloadArchiver;
import com.intel.cosbench.controller.archiver.WorkloadArchiver;
import com.intel.cosbench.controller.loader.SimpleWorkloadLoader;
import com.intel.cosbench.controller.model.ControllerContext;
import com.intel.cosbench.controller.model.WorkloadContext;
import com.intel.cosbench.controller.model.WorkloadListener;
import com.intel.cosbench.controller.repository.RAMWorkloadRepository;
import com.intel.cosbench.controller.repository.WorkloadRepository;
import com.intel.cosbench.controller.service.ControllerThread;
import com.intel.cosbench.controller.service.OrderFutureComparator;
import com.intel.cosbench.controller.service.OrderThreadPoolExecutor;
import com.intel.cosbench.controller.service.PingDriverRunner;
import com.intel.cosbench.controller.service.WorkloadProcessor;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.ControllerInfo;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.model.WorkloadState;
import com.intel.cosbench.service.ControllerService;
import com.intel.cosbench.service.WorkloadLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

class COSBControllerService
implements ControllerService,
WorkloadListener {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private AtomicInteger count;
    private AtomicInteger order;
    private ControllerContext context;
    private Map<String, WorkloadProcessor> processors;
    private OrderThreadPoolExecutor executor;
    private WorkloadArchiver archiver = new SimpleWorkloadArchiver();
    private WorkloadLoader loader = new SimpleWorkloadLoader();
    private WorkloadRepository memRepo = new RAMWorkloadRepository();
    private boolean loadArch = false;

    public void setContext(ControllerContext context) {
        this.context = context;
        Thread pingDriverThread = new Thread(new PingDriverRunner(context.getDriverInfos()));
        pingDriverThread.start();
    }

    public void init() {
        if (this.context == null) {
            LOGGER.error("Controller Context is not initialized.");
            System.exit(-1);
        }
        String archive_dir = this.context.getArchive_dir();
        this.archiver = new SimpleWorkloadArchiver(archive_dir);
        this.loader = new SimpleWorkloadLoader(archive_dir);
        this.count = new AtomicInteger(this.archiver.getTotalWorkloads());
        this.order = new AtomicInteger(0);
        this.processors = new HashMap<String, WorkloadProcessor>();
        this.processors = Collections.synchronizedMap(this.processors);
        int concurrency = this.context.getConcurrency();
        this.executor = new OrderThreadPoolExecutor(concurrency, concurrency, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(this.memRepo.getMaxCapacity(), new OrderFutureComparator()));
    }

    public void loadArchivedWorkload() throws IOException {
        List workloadContexts = this.loader.loadWorkloadRun();
        if (workloadContexts == null) {
            return;
        }
        for (WorkloadInfo workloadContext : workloadContexts) {
            this.memRepo.saveWorkload((WorkloadContext)workloadContext);
        }
    }

    public void unloadArchivedWorkload() {
        WorkloadContext[] workloadContextArray = this.memRepo.getArchivedWorkloads();
        int n = workloadContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkloadContext workload = workloadContextArray[n2];
            this.memRepo.removeWorkload(workload);
            Object var1_4 = null;
            ++n2;
        }
    }

    public synchronized String submit(XmlConfig config) {
        LOGGER.debug("[ CT ] - submitting workload ... ");
        WorkloadContext workload = this.createWorkloadContext(config);
        WorkloadProcessor processor = this.createProcessor(workload);
        workload.addListener(this);
        this.processors.put(workload.getId(), processor);
        this.memRepo.saveWorkload(workload);
        LOGGER.debug("[ CT ] - workload {} submitted", (Object)workload.getId());
        return workload.getId();
    }

    public String resubmit(String id) throws IOException {
        XmlConfig config = SimpleWorkloadLoader.getWorkloadConfg(this.memRepo.getWorkload(id));
        if (config != null) {
            return this.submit(config);
        }
        LOGGER.debug("[ CT ] - workload {} resubmitted failed, has no workload config", (Object)id);
        throw new FileNotFoundException("configuration file for workload " + id);
    }

    private WorkloadContext createWorkloadContext(XmlConfig config) {
        WorkloadContext context = new WorkloadContext();
        context.setId(this.generateWorkloadId());
        context.setOrder(this.generateOrder());
        context.setSubmitDate(new Date());
        context.setConfig(config);
        context.setState(WorkloadState.QUEUING);
        return context;
    }

    public WorkloadLoader getWorkloadLoader() {
        return this.loader;
    }

    public boolean getloadArch() {
        return this.loadArch;
    }

    public void setloadArch(boolean loadArch) {
        this.loadArch = loadArch;
        if (this.getloadArch()) {
            try {
                this.loadArchivedWorkload();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.unloadArchivedWorkload();
        }
    }

    private String generateWorkloadId() {
        return "w" + this.count.incrementAndGet();
    }

    private int generateOrder() {
        return this.order.incrementAndGet();
    }

    private WorkloadProcessor createProcessor(WorkloadContext workload) {
        WorkloadProcessor processor = new WorkloadProcessor();
        processor.setControllerContext(this.context);
        processor.setWorkloadContext(workload);
        processor.init();
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(String id) {
        if (id == null) {
            throw new IllegalStateException("invalid workload id.");
        }
        WorkloadProcessor processor = this.processors.get(id);
        if (processor == null) {
            throw new IllegalStateException("workload processor is not initialized.");
        }
        LOGGER.debug("[ CT ] - starting workload {} ...", (Object)id);
        if (processor.getWorkloadContext().getFuture() != null) {
            throw new IllegalStateException();
        }
        ControllerThread ctrlThrd = new ControllerThread(processor);
        Future<?> future = null;
        WorkloadProcessor workloadProcessor = processor;
        synchronized (workloadProcessor) {
            future = this.executor.submit(ctrlThrd);
            processor.getWorkloadContext().setFuture(future);
        }
        LOGGER.debug("[ CT ] - workload {} started", (Object)id);
        COSBControllerService.yieldExecution(200);
    }

    public boolean changeOrder(String id, String neighbourWId, boolean up) {
        int i;
        int neighOrder;
        int order;
        if (StringUtils.isEmpty((String)neighbourWId)) {
            return this.changeOrder(id, up);
        }
        if (neighbourWId.equals(String.valueOf(0))) {
            return false;
        }
        if (!up == (order = this.processors.get(id).getWorkloadContext().getOrder()) > (neighOrder = this.processors.get(neighbourWId).getWorkloadContext().getOrder())) {
            return false;
        }
        if (this.processors.get(neighbourWId).getWorkloadContext().getState() != WorkloadState.QUEUING) {
            LOGGER.error("[ CT ] - workload {} order failed cause it's highest order...", (Object)id);
            return false;
        }
        ArrayList<Integer> orders = new ArrayList<Integer>();
        HashMap<String, String> orderWorkloadMap = new HashMap<String, String>();
        WorkloadContext[] workloadContextArray = this.getActiveWorkloads();
        int n = workloadContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkloadContext workload = workloadContextArray[n2];
            if (workload.getOrder() >= order && workload.getOrder() <= neighOrder || workload.getOrder() <= order && workload.getOrder() >= neighOrder) {
                orders.add(workload.getOrder());
                orderWorkloadMap.put(String.valueOf(workload.getOrder()), workload.getId());
            }
            ++n2;
        }
        Object[] orderArray = orders.toArray(new Integer[orders.size()]);
        Arrays.sort(orderArray);
        if (up) {
            i = orderArray.length - 2;
            while (i >= 0) {
                this.processors.get(orderWorkloadMap.get(String.valueOf(orderArray[i]))).getWorkloadContext().setOrder((Integer)orderArray[i + 1]);
                --i;
            }
        } else {
            i = 1;
            while (i < orderArray.length) {
                this.processors.get(orderWorkloadMap.get(String.valueOf(orderArray[i]))).getWorkloadContext().setOrder((Integer)orderArray[i - 1]);
                ++i;
            }
        }
        this.processors.get(id).getWorkloadContext().setOrder(neighOrder);
        for (String workloadId : orderWorkloadMap.values()) {
            if (!this.processors.get(workloadId).getWorkloadContext().getFuture().cancel(true)) {
                LOGGER.error("[ CT ] - change workload {} order failed cause can't remove workload...", (Object)workloadId);
                return false;
            }
            this.processors.get(workloadId).getWorkloadContext().setFuture(null);
            this.fire(workloadId);
        }
        return true;
    }

    public boolean changeOrder(String id, boolean up) {
        int i;
        int order = this.processors.get(id).getWorkloadContext().getOrder();
        int neighbourOrder = 0;
        ArrayList<Integer> orders = new ArrayList<Integer>();
        WorkloadContext[] workloadContextArray = this.getActiveWorkloads();
        int n = workloadContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkloadContext workload = workloadContextArray[n2];
            orders.add(workload.getOrder());
            ++n2;
        }
        Object[] orderArray = orders.toArray(new Integer[orders.size()]);
        Arrays.sort(orderArray);
        if (up) {
            i = orderArray.length - 1;
            while (i >= 0) {
                if ((Integer)orderArray[i] < order) {
                    neighbourOrder = (Integer)orderArray[i];
                    break;
                }
                --i;
            }
        } else {
            i = 0;
            while (i < orderArray.length) {
                if ((Integer)orderArray[i] > order) {
                    neighbourOrder = (Integer)orderArray[i];
                    break;
                }
                ++i;
            }
        }
        String neighbourWId = String.valueOf(0);
        WorkloadContext[] workloadContextArray2 = this.getActiveWorkloads();
        int n3 = workloadContextArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            WorkloadContext workload = workloadContextArray2[n4];
            if (workload.getOrder() == neighbourOrder) {
                neighbourWId = workload.getId();
            }
            ++n4;
        }
        if (neighbourWId.equals(String.valueOf(0))) {
            return false;
        }
        if (this.processors.get(neighbourWId).getWorkloadContext().getState() != WorkloadState.QUEUING) {
            LOGGER.debug("[ CT ] - workload {} order failed cause it's highest order...", (Object)id);
            return false;
        }
        if (!this.processors.get(id).getWorkloadContext().getFuture().cancel(true) || !this.processors.get(neighbourWId).getWorkloadContext().getFuture().cancel(true)) {
            LOGGER.error("[ CT ] - change workload {} {} order failed cause can't remove workload...", (Object)id, (Object)neighbourWId);
            return false;
        }
        this.processors.get(id).getWorkloadContext().setFuture(null);
        this.processors.get(neighbourWId).getWorkloadContext().setFuture(null);
        this.processors.get(id).getWorkloadContext().setOrder(neighbourOrder);
        this.processors.get(neighbourWId).getWorkloadContext().setOrder(order);
        this.fire(id);
        this.fire(neighbourWId);
        return true;
    }

    public void cancel(String id) {
        WorkloadProcessor processor = this.processors.get(id);
        if (processor == null) {
            return;
        }
        LOGGER.debug("[ CT ] - canceling workload{} ...", (Object)id);
        processor.cancel();
        COSBControllerService.yieldExecution(500);
        LOGGER.debug("[ CT ] - workload {} cancelled", (Object)id);
    }

    private static void yieldExecution(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("get interrupted when performing yield");
            Thread.currentThread().interrupt();
        }
    }

    public ControllerInfo getControllerInfo() {
        return this.context;
    }

    public WorkloadContext getWorkloadInfo(String id) {
        return this.memRepo.getWorkload(id);
    }

    public WorkloadContext[] getActiveWorkloads() {
        return this.memRepo.getActiveWorkloads();
    }

    public WorkloadContext[] getHistoryWorkloads() {
        return this.memRepo.getInactiveWorkloads();
    }

    public WorkloadInfo[] getArchivedWorkloads() {
        return this.memRepo.getArchivedWorkloads();
    }

    @Override
    public void workloadStarted(WorkloadContext workload) {
    }

    @Override
    public void workloadStopped(WorkloadContext workload) {
        String id = workload.getId();
        WorkloadProcessor processor = this.processors.remove(id);
        processor.dispose();
        this.archiver.archive(workload);
        LOGGER.debug("processor for workload {} has been detached", (Object)id);
    }

    public File getWorkloadLog(WorkloadInfo info) {
        return this.archiver.getWorkloadLog(info);
    }

    public File getWorkloadConfig(WorkloadInfo info) {
        return this.archiver.getWorkloadConfig(info);
    }
}

