/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.schedule;

import com.intel.cosbench.config.Work;
import com.intel.cosbench.controller.model.DriverContext;
import com.intel.cosbench.controller.model.ScheduleRegistry;
import com.intel.cosbench.controller.schedule.AbstractScheduler;
import com.intel.cosbench.controller.schedule.ScheduleException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

class BalancedScheduler
extends AbstractScheduler {
    private int allocIdx;
    private int[] allocMap;
    private ScheduleRegistry schedules = new ScheduleRegistry();

    @Override
    public ScheduleRegistry schedule() {
        this.honorUserSchedules();
        this.scheduleRestWorks();
        return this.schedules;
    }

    private void honorUserSchedules() {
        HashSet<String> toRemove = new HashSet<String>();
        ArrayList<Work> unscheduled = new ArrayList<Work>();
        for (Work work : this.works) {
            DriverContext driver = this.fetchDriver(work.getDriver());
            if (driver == null) {
                unscheduled.add(work);
                continue;
            }
            toRemove.add(driver.getName());
            this.schedules.addSchedule(BalancedScheduler.createSchedule(work, driver));
        }
        for (String driver : toRemove) {
            this.drivers.remove(driver);
        }
        this.works = unscheduled;
    }

    private void scheduleRestWorks() {
        if (this.works.size() == 0) {
            return;
        }
        if (this.drivers.size() == 0) {
            throw new ScheduleException("no free driver available");
        }
        this.allocIdx = 0;
        this.allocMap = new int[this.drivers.size()];
        for (Work work : this.works) {
            this.doSchedule(work);
        }
    }

    private void doSchedule(Work work) {
        int driverNum = this.allocMap.length;
        int base = work.getWorkers() / driverNum;
        int extra = work.getWorkers() % driverNum;
        int i = 0;
        while (i < driverNum) {
            this.allocMap[i] = base;
            ++i;
        }
        int lower = this.allocIdx;
        int upper = lower + extra;
        int i2 = lower;
        while (i2 < upper) {
            int n = i2 % driverNum;
            this.allocMap[n] = this.allocMap[n] + 1;
            ++i2;
        }
        this.allocIdx = upper % driverNum;
        int idx = 0;
        int offset = 0;
        int workers = 0;
        for (DriverContext driver : this.drivers.values()) {
            if ((workers = this.allocMap[idx++]) == 0) continue;
            this.schedules.addSchedule(BalancedScheduler.createSchedule(work, driver, offset, workers));
            offset += workers;
        }
    }

    private DriverContext fetchDriver(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        if (StringUtils.equals((String)name, (String)"none")) {
            return null;
        }
        return (DriverContext)this.drivers.get(name);
    }
}

