/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.schedule;

import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.controller.model.DriverContext;
import com.intel.cosbench.controller.model.DriverRegistry;
import com.intel.cosbench.controller.model.SchedulePlan;
import com.intel.cosbench.controller.schedule.WorkScheduler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractScheduler
implements WorkScheduler {
    protected List<Work> works = new ArrayList<Work>();
    protected Map<String, DriverContext> drivers = new LinkedHashMap<String, DriverContext>();

    protected void init(Stage stage, DriverRegistry registry) {
        for (Work work : stage) {
            this.works.add(work);
        }
        Iterator iterator = registry.iterator();
        while (iterator.hasNext()) {
            DriverContext driver = (DriverContext)iterator.next();
            this.drivers.put(driver.getName(), driver);
        }
    }

    protected static SchedulePlan createSchedule(Work work, DriverContext driver, int offset, int workers) {
        SchedulePlan plan = new SchedulePlan();
        plan.setWork(work);
        plan.setDriver(driver);
        plan.setOffset(offset);
        plan.setWorkers(workers);
        return plan;
    }

    protected static SchedulePlan createSchedule(Work work, DriverContext driver) {
        return AbstractScheduler.createSchedule(work, driver, 0, work.getWorkers());
    }
}

