/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.repository;

import com.intel.cosbench.controller.model.WorkloadContext;
import com.intel.cosbench.controller.repository.WorkloadList;
import com.intel.cosbench.model.WorkloadState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class SimpleWorkloadList
implements WorkloadList {
    private int maxCapacity;
    private int capacity = 0;
    private Map<String, WorkloadContext> list;
    private List<WorkloadContext> toBeRemoved;

    public SimpleWorkloadList(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.list = new LinkedHashMap<String, WorkloadContext>(maxCapacity);
        this.toBeRemoved = new ArrayList<WorkloadContext>();
    }

    @Override
    public int count() {
        return this.list.size();
    }

    @Override
    public WorkloadContext fetch(String id) {
        return this.list.get(id);
    }

    @Override
    public WorkloadContext[] add(WorkloadContext workload) {
        this.toBeRemoved.clear();
        this.list.put(workload.getId(), workload);
        this.capacity = this.count();
        this.shrinkListSize();
        WorkloadContext[] result = new WorkloadContext[this.toBeRemoved.size()];
        result = this.toBeRemoved.toArray(result);
        this.toBeRemoved.clear();
        return result;
    }

    @Override
    public void remove(WorkloadContext workload) {
        this.list.remove(workload.getId());
    }

    private void shrinkListSize() {
        Iterator<WorkloadContext> iter = this.list.values().iterator();
        while (this.capacity > this.maxCapacity && iter.hasNext()) {
            this.tryRemoveWorkloads(iter);
        }
    }

    private void tryRemoveWorkloads(Iterator<WorkloadContext> iter) {
        WorkloadContext workload = iter.next();
        if (!WorkloadState.isStopped((WorkloadState)workload.getState())) {
            return;
        }
        iter.remove();
        --this.capacity;
        this.toBeRemoved.add(workload);
    }

    @Override
    public Collection<WorkloadContext> values() {
        return this.list.values();
    }
}

