/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.repository;

import com.intel.cosbench.controller.model.WorkloadContext;
import com.intel.cosbench.controller.model.WorkloadListener;
import com.intel.cosbench.controller.repository.SimpleWorkloadList;
import com.intel.cosbench.controller.repository.WorkloadList;
import com.intel.cosbench.controller.repository.WorkloadRepository;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.WorkloadState;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class RAMWorkloadRepository
implements WorkloadRepository,
WorkloadListener {
    private static final int MAX_WORKLOAD_DEFAULT = 100;
    private static final String MAX_WORKLOAD_KEY = "cosbench.controller.history";
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private File stops = new File("stop");
    private File starts = new File("start");
    private WorkloadList workloads;

    public RAMWorkloadRepository() {
        SimpleWorkloadList workloads = new SimpleWorkloadList(this.getMaxCapacity());
        this.workloads = workloads;
    }

    @Override
    public int getMaxCapacity() {
        int maxCapacity = 100;
        String config = System.getProperty(MAX_WORKLOAD_KEY);
        if (!StringUtils.isEmpty((String)config)) {
            try {
                maxCapacity = Integer.parseInt(config);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        LOGGER.debug("will hold {} workloads in RAM", (Object)maxCapacity);
        return maxCapacity;
    }

    @Override
    public synchronized int getSize() {
        return this.workloads.count();
    }

    @Override
    public synchronized void saveWorkload(WorkloadContext workload) {
        workload.addListener(this);
        WorkloadContext[] removed = this.workloads.add(workload);
        LOGGER.debug("workload {} has been saved in RAM", (Object)workload.getId());
        LOGGER.debug("{} workloads have been removed from RAM", (Object)removed.length);
    }

    @Override
    public synchronized void removeWorkload(WorkloadContext workload) {
        this.workloads.remove(workload);
    }

    @Override
    public synchronized WorkloadContext getWorkload(String id) {
        return this.workloads.fetch(id);
    }

    @Override
    public synchronized WorkloadContext[] getAllWorkloads() {
        int size = this.workloads.count();
        return this.workloads.values().toArray(new WorkloadContext[size]);
    }

    @Override
    public synchronized WorkloadContext[] getActiveWorkloads() {
        ArrayList<WorkloadContext> result = new ArrayList<WorkloadContext>();
        for (WorkloadContext workload : this.workloads.values()) {
            if (WorkloadState.isStopped((WorkloadState)workload.getState())) continue;
            result.add(workload);
        }
        return result.toArray(new WorkloadContext[result.size()]);
    }

    @Override
    public synchronized WorkloadContext[] getInactiveWorkloads() {
        ArrayList<WorkloadContext> result = new ArrayList<WorkloadContext>();
        for (WorkloadContext workload : this.workloads.values()) {
            if (!WorkloadState.isStopped((WorkloadState)workload.getState()) || workload.getArchived()) continue;
            result.add(workload);
        }
        return result.toArray(new WorkloadContext[result.size()]);
    }

    @Override
    public synchronized WorkloadContext[] getArchivedWorkloads() {
        ArrayList<WorkloadContext> result = new ArrayList<WorkloadContext>();
        for (WorkloadContext workload : this.workloads.values()) {
            if (!workload.getArchived()) continue;
            result.add(workload);
        }
        return result.toArray(new WorkloadContext[result.size()]);
    }

    @Override
    public void workloadStarted(WorkloadContext workload) {
        this.markAsStarted(workload);
    }

    private void markAsStarted(WorkloadContext workload) {
        try {
            this.appendToStarts(workload);
        }
        catch (Exception e) {
            LOGGER.error("fail to mark workload", (Throwable)e);
        }
    }

    private void appendToStarts(WorkloadContext workload) throws IOException {
        String id = workload.getId();
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.starts, true));
        try {
            writer.write(id);
            ((Writer)writer).write(10);
            ((Writer)writer).flush();
        }
        finally {
            ((Writer)writer).close();
        }
        String path = this.starts.getAbsolutePath();
        LOGGER.debug("workload {} has been appened to {}", (Object)id, (Object)path);
    }

    @Override
    public void workloadStopped(WorkloadContext workload) {
        this.markAsStopped(workload);
        String id = workload.getId();
        workload.disposeRuntime();
        LOGGER.debug("runtime resources have been released for workload {}", (Object)id);
    }

    private void markAsStopped(WorkloadContext workload) {
        try {
            this.appendToStops(workload);
        }
        catch (Exception e) {
            LOGGER.error("fail to mark workload", (Throwable)e);
        }
    }

    private void appendToStops(WorkloadContext workload) throws IOException {
        String id = workload.getId();
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.stops, true));
        try {
            writer.write(id);
            ((Writer)writer).write(10);
            ((Writer)writer).flush();
        }
        finally {
            ((Writer)writer).close();
        }
        String path = this.stops.getAbsolutePath();
        LOGGER.debug("workload {} has been appened to {}", (Object)id, (Object)path);
    }
}

