/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.model;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.Snapshot;
import com.intel.cosbench.config.Operation;
import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.config.Workload;
import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.controller.model.DriverRegistry;
import com.intel.cosbench.controller.model.ErrorSummary;
import com.intel.cosbench.controller.model.StageContext;
import com.intel.cosbench.controller.model.StageRegistry;
import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.model.WorkloadListener;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.DriverInfo;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.StateInfo;
import com.intel.cosbench.model.StateRegistry;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.model.WorkloadState;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class WorkloadContext
implements WorkloadInfo {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private String id;
    private Date submitDate;
    private Date startDate;
    private Date stopDate;
    private volatile WorkloadState state;
    private StateRegistry stateHistory = new StateRegistry();
    private transient XmlConfig config;
    private volatile transient Future<?> future;
    private Workload workload;
    private volatile transient StageInfo currentStage;
    private StageRegistry stageRegistry;
    private int order;
    private DriverRegistry driverRegistry;
    private volatile Report report = null;
    private transient List<WorkloadListener> listeners = new ArrayList<WorkloadListener>();
    private String[] opInfo;
    private boolean archived = false;
    private HashMap<String, ErrorSummary> errorStatistics = new HashMap();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate;
    }

    public WorkloadState getState() {
        return this.state;
    }

    public void setState(WorkloadState state) {
        this.state = state;
        if (this.archived) {
            return;
        }
        this.stateHistory.addState(state.name());
        if (WorkloadState.isRunning((WorkloadState)state)) {
            this.fireWorkloadStarted();
        }
        if (WorkloadState.isStopped((WorkloadState)state)) {
            this.fireWorkloadStopped();
        }
    }

    public void setState(String state, Date date) {
        this.stateHistory.addState(state, date);
    }

    private void fireWorkloadStarted() {
        for (WorkloadListener listener : this.listeners) {
            listener.workloadStarted(this);
        }
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public boolean getArchived() {
        return this.archived;
    }

    private void fireWorkloadStopped() {
        if (this.report == null) {
            this.report = this.mergeReport();
        }
        for (WorkloadListener listener : this.listeners) {
            listener.workloadStopped(this);
        }
    }

    private Report mergeReport() {
        Report report = new Report();
        Iterator iterator = this.stageRegistry.iterator();
        while (iterator.hasNext()) {
            StageContext stage = (StageContext)iterator.next();
            int mid = 1;
            for (Metrics metrics : stage.getReport()) {
                Metrics clone = metrics.clone();
                String uuid = String.valueOf(this.id) + "-" + stage.getId() + "-" + mid++;
                clone.setName(uuid);
                report.addMetrics(clone);
            }
        }
        return report;
    }

    public StateInfo[] getStateHistory() {
        return this.stateHistory.getAllStates();
    }

    public XmlConfig getConfig() {
        return this.config;
    }

    public void setConfig(XmlConfig config) {
        this.config = config;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    public void setFuture(Future<?> future) {
        this.future = future;
    }

    public Workload getWorkload() {
        return this.workload;
    }

    public void setWorkload(Workload workload) {
        this.workload = workload;
    }

    public String[] getOpInfo() {
        return this.opInfo;
    }

    public void setOpInfo(String[] opInfo) {
        this.opInfo = opInfo;
    }

    public String[] getAllOperations() {
        if (this.opInfo == null) {
            LinkedHashSet<String> ops = new LinkedHashSet<String>();
            for (Stage stage : this.workload.getWorkflow()) {
                for (Work work : stage) {
                    for (Operation op : work) {
                        ops.add(op.getType());
                    }
                }
            }
            this.setOpInfo(ops.toArray(new String[ops.size()]));
        }
        return this.getOpInfo();
    }

    public StageInfo getCurrentStage() {
        return this.currentStage;
    }

    public void setCurrentStage(StageInfo currentStage) {
        this.currentStage = currentStage;
    }

    public StageRegistry getStageRegistry() {
        return this.stageRegistry;
    }

    public int getStageCount() {
        return this.stageRegistry.getSize();
    }

    public StageInfo getStageInfo(String id) {
        Iterator iterator = this.stageRegistry.iterator();
        while (iterator.hasNext()) {
            StageInfo info = (StageInfo)iterator.next();
            if (!info.getId().equals(id)) continue;
            return info;
        }
        return null;
    }

    public StageInfo[] getStageInfos() {
        return this.stageRegistry.getAllStages();
    }

    public void setStageRegistry(StageRegistry stageRegistry) {
        this.stageRegistry = stageRegistry;
    }

    public int getSnapshotCount() {
        int total = 0;
        Iterator iterator = this.stageRegistry.iterator();
        while (iterator.hasNext()) {
            StageInfo info = (StageInfo)iterator.next();
            total += info.getSnapshotCount();
        }
        return total;
    }

    public Snapshot getSnapshot() {
        if (this.currentStage == null) {
            return new Snapshot();
        }
        return this.currentStage.getSnapshot();
    }

    public Report getReport() {
        return this.report != null ? this.report : new Report();
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void addListener(WorkloadListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public HashMap<String, ErrorSummary> getErrorStatistics() {
        return this.errorStatistics;
    }

    public void mergeErrorStatistics() {
        Iterator iterator = this.stageRegistry.iterator();
        while (iterator.hasNext()) {
            StageContext stageContext = (StageContext)iterator.next();
            Iterator iterator2 = stageContext.getTaskRegistry().iterator();
            while (iterator2.hasNext()) {
                TaskContext taskContext = (TaskContext)iterator2.next();
                String driverUrl = taskContext.getSchedule().getDriver().getUrl();
                if (!this.errorStatistics.containsKey(driverUrl)) {
                    this.errorStatistics.put(driverUrl, new ErrorSummary(taskContext.getErrorStatistics()));
                    continue;
                }
                HashMap<Object, Object> source = new HashMap();
                source = taskContext.getErrorStatistics();
                HashMap<String, Integer> merge = this.errorStatistics.get(driverUrl).getErrorCodeAndNum();
                for (Map.Entry<Object, Object> entry : source.entrySet()) {
                    if (!merge.containsKey(entry.getKey())) {
                        merge.put((String)entry.getKey(), (Integer)entry.getValue());
                        continue;
                    }
                    Integer value = merge.get(entry.getKey()) + (Integer)entry.getValue();
                    merge.put((String)entry.getKey(), value);
                }
                this.errorStatistics.put(driverUrl, new ErrorSummary(merge));
            }
        }
    }

    public void logErrorStatistics(Logger logger) {
        for (Map.Entry<String, ErrorSummary> driverEntry : this.errorStatistics.entrySet()) {
            for (Map.Entry<String, Integer> codeEntry : driverEntry.getValue().getErrorCodeAndNum().entrySet()) {
                logger.warn(String.valueOf(driverEntry.getKey()) + " : " + codeEntry.getKey() + " occured " + codeEntry.getValue());
            }
        }
    }

    public void disposeRuntime() {
        Iterator iterator = this.stageRegistry.iterator();
        while (iterator.hasNext()) {
            StageContext stage = (StageContext)iterator.next();
            stage.disposeRuntime();
        }
        this.config = null;
        this.future = null;
        this.currentStage = null;
        this.listeners = null;
    }

    public DriverRegistry getDriverRegistry() {
        return this.driverRegistry;
    }

    public void setDriverRegistry(DriverRegistry driverRegistry) {
        this.driverRegistry = driverRegistry;
    }

    public DriverInfo[] getDriverInfos() {
        return this.driverRegistry.getAllDrivers();
    }
}

