/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.model;

import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.ReportMerger;
import com.intel.cosbench.bench.Snapshot;
import com.intel.cosbench.bench.SnapshotMerger;
import com.intel.cosbench.bench.TaskReport;
import com.intel.cosbench.config.Operation;
import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.controller.model.ScheduleRegistry;
import com.intel.cosbench.controller.model.SnapshotRegistry;
import com.intel.cosbench.controller.model.StageListener;
import com.intel.cosbench.controller.model.TaskContext;
import com.intel.cosbench.controller.model.TaskRegistry;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.StageState;
import com.intel.cosbench.model.StateInfo;
import com.intel.cosbench.model.StateRegistry;
import com.intel.cosbench.model.TaskInfo;
import com.intel.cosbench.utils.ListRegistry;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class StageContext
implements StageInfo {
    private String id;
    private volatile StageState state;
    private StateRegistry stateHistory = new StateRegistry();
    private Stage stage;
    private int interval;
    private transient ScheduleRegistry scheduleRegistry;
    private TaskRegistry taskRegistry;
    private SnapshotRegistry snapshotRegistry = new SnapshotRegistry();
    private volatile Report report = null;
    private transient List<StageListener> listeners = new ArrayList<StageListener>();
    private List<TaskReport> taskReports = new ArrayList<TaskReport>();

    public List<TaskReport> getTaskReports() {
        return this.taskReports;
    }

    public void setTaskReports(List<TaskReport> taskReports) {
        this.taskReports = taskReports;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public StageState getState() {
        return this.state;
    }

    public void setState(StageState state) {
        this.setState(state, false);
    }

    public void setState(StageState state, boolean archived) {
        this.state = state;
        if (archived) {
            return;
        }
        this.stateHistory.addState(state.name());
        if (StageState.isStopped((StageState)state)) {
            this.fireStageStopped();
        }
    }

    public void setState(String state, Date date) {
        this.stateHistory.addState(state, date);
    }

    private void fireStageStopped() {
        if (this.report == null) {
            this.report = this.mergeReport();
        }
        for (StageListener listener : this.listeners) {
            listener.stageStopped(this);
        }
    }

    public Report mergeReport() {
        if (this.taskRegistry == null) {
            return new Report();
        }
        ReportMerger merger = new ReportMerger();
        Iterator iterator = this.taskRegistry.iterator();
        while (iterator.hasNext()) {
            TaskContext task = (TaskContext)iterator.next();
            TaskReport tReport = new TaskReport();
            tReport.setReport(task.getReport());
            tReport.setDriverName(task.getSchedule().getDriver().getName());
            tReport.setDriverUrl(task.getSchedule().getDriver().getUrl());
            this.taskReports.add(tReport);
            merger.add(task.getReport());
        }
        return merger.merge();
    }

    public StateInfo[] getStateHistory() {
        return this.stateHistory.getAllStates();
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public int getWorkCount() {
        return this.stage.getWorks().size();
    }

    public int getWorkerCount() {
        int workers = 0;
        for (Work work : this.stage) {
            workers += work.getWorkers();
        }
        return workers;
    }

    public Set<String> getOperations() {
        LinkedHashSet<String> ops = new LinkedHashSet<String>();
        for (Work work : this.stage) {
            for (Operation op : work) {
                ops.add(op.getType());
            }
        }
        return ops;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public ScheduleRegistry getScheduleRegistry() {
        return this.scheduleRegistry;
    }

    public void setScheduleRegistry(ScheduleRegistry scheduleRegistry) {
        this.scheduleRegistry = scheduleRegistry;
    }

    public TaskRegistry getTaskRegistry() {
        return this.taskRegistry;
    }

    public int getTaskCount() {
        return this.taskRegistry == null ? 0 : this.taskRegistry.getSize();
    }

    public TaskInfo[] getTaskInfos() {
        if (this.taskRegistry == null) {
            return new TaskInfo[0];
        }
        return this.taskRegistry.getAllTasks();
    }

    public void setTaskRegistry(TaskRegistry taskRegistry) {
        this.taskRegistry = taskRegistry;
    }

    public Snapshot getSnapshot() {
        if (this.taskRegistry == null) {
            return new Snapshot();
        }
        SnapshotMerger merger = new SnapshotMerger();
        Iterator iterator = this.taskRegistry.iterator();
        while (iterator.hasNext()) {
            TaskContext worker = (TaskContext)iterator.next();
            merger.add(worker.getSnapshot());
        }
        return merger.merge();
    }

    public Report getReport() {
        return this.report != null ? this.report : new Report();
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public Snapshot[] getSnapshots() {
        return this.snapshotRegistry.getAllSnapshot();
    }

    public int getSnapshotCount() {
        return this.snapshotRegistry.getSize();
    }

    public void makeSnapshot() {
        this.snapshotRegistry.addSnapshot(this.getSnapshot());
    }

    public void addListener(StageListener listener) {
        this.listeners.add(listener);
    }

    public void disposeRuntime() {
        if (this.taskRegistry != null) {
            Iterator iterator = this.taskRegistry.iterator();
            while (iterator.hasNext()) {
                TaskContext task = (TaskContext)iterator.next();
                task.disposeRuntime();
            }
        }
        this.scheduleRegistry = null;
        this.listeners = null;
    }

    public ListRegistry<Snapshot> getSnapshotRegistry() {
        return this.snapshotRegistry;
    }
}

