/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.loader;

import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.WorkloadResolver;
import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.config.castor.CastorConfigTools;
import com.intel.cosbench.controller.loader.Loaders;
import com.intel.cosbench.controller.loader.RunLoader;
import com.intel.cosbench.controller.loader.SnapshotLoader;
import com.intel.cosbench.controller.loader.WorkloadFileLoader;
import com.intel.cosbench.controller.model.StageContext;
import com.intel.cosbench.controller.model.StageRegistry;
import com.intel.cosbench.controller.model.WorkloadContext;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.StageState;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.service.WorkloadLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SimpleWorkloadLoader
implements WorkloadLoader {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private static File ARCHIVE_DIR = new File("archive");

    public SimpleWorkloadLoader() {
        this("archive");
    }

    public SimpleWorkloadLoader(String archive) {
        ARCHIVE_DIR = new File(archive);
        if (!ARCHIVE_DIR.exists()) {
            ARCHIVE_DIR.mkdirs();
        }
        String path = ARCHIVE_DIR.getAbsolutePath();
        LOGGER.info("loading workload archives from {}", (Object)path);
    }

    private static String getRunDirName(WorkloadInfo info) {
        String name = info.getId();
        name = String.valueOf(name) + '-' + info.getWorkload().getName();
        return name;
    }

    public List<WorkloadInfo> loadWorkloadRun() throws IOException {
        File file = new File(ARCHIVE_DIR, "run-history.csv");
        if (!file.exists()) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        RunLoader loader = Loaders.newRunExporter(reader);
        ArrayList<WorkloadInfo> workloads = new ArrayList();
        workloads = loader.load();
        if (reader != null) {
            reader.close();
        }
        return workloads;
    }

    public void loadWorkloadPageInfo(WorkloadInfo workloadContext) throws IOException {
        this.loadWorkloadConfig(workloadContext);
        this.loadWorkloadFile(workloadContext);
    }

    private void loadWorkloadConfig(WorkloadInfo workloadContext) throws FileNotFoundException {
        XmlConfig config = SimpleWorkloadLoader.getWorkloadConfg(workloadContext);
        if (config != null) {
            WorkloadResolver resolver = CastorConfigTools.getWorkloadResolver();
            workloadContext.setWorkload(resolver.toWorkload(config));
            this.createStages(workloadContext);
        } else {
            ((WorkloadContext)workloadContext).setStageRegistry(new StageRegistry());
        }
    }

    public static XmlConfig getWorkloadConfg(WorkloadInfo workloadContext) throws FileNotFoundException {
        File file = new File(new File(ARCHIVE_DIR, SimpleWorkloadLoader.getRunDirName(workloadContext)), "workload-config.xml");
        if (!file.exists()) {
            return null;
        }
        XmlConfig config = new XmlConfig((InputStream)new FileInputStream(file));
        return config;
    }

    private void createStages(WorkloadInfo workloadContext) {
        StageRegistry registry = new StageRegistry();
        int index = 1;
        for (Stage stage : workloadContext.getWorkload().getWorkflow()) {
            String id = "s" + index++;
            registry.addStage(SimpleWorkloadLoader.createStageContext(id, stage));
        }
        ((WorkloadContext)workloadContext).setStageRegistry(registry);
    }

    private static StageContext createStageContext(String id, Stage stage) {
        StageContext context = new StageContext();
        context.setId(id);
        context.setStage(stage);
        context.setState(StageState.COMPLETED, true);
        return context;
    }

    private static String getWorkloadFileName(WorkloadInfo info) {
        String name = info.getId();
        name = String.valueOf(name) + "-" + info.getWorkload().getName();
        return name;
    }

    private void loadWorkloadFile(WorkloadInfo workloadContext) throws IOException {
        File file = new File(new File(ARCHIVE_DIR, SimpleWorkloadLoader.getRunDirName(workloadContext)), String.valueOf(SimpleWorkloadLoader.getWorkloadFileName(workloadContext)) + ".csv");
        if (!file.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        WorkloadFileLoader loader = Loaders.newWorkloadLoader(reader, workloadContext);
        loader.load();
    }

    private static String getStageFileName(StageInfo info) {
        String name = info.getId();
        name = String.valueOf(name) + "-" + info.getStage().getName();
        return name;
    }

    public void loadStagePageInfo(WorkloadInfo workloadContext, String stageId) throws IOException {
        File file = new File(new File(ARCHIVE_DIR, SimpleWorkloadLoader.getRunDirName(workloadContext)), String.valueOf(SimpleWorkloadLoader.getStageFileName(workloadContext.getStageInfo(stageId))) + ".csv");
        if (!file.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        SnapshotLoader loader = Loaders.newSnapshotLoader(reader, workloadContext, stageId);
        loader.load();
    }
}

