/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.loader;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.Snapshot;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.controller.loader.AbstractSnapshotLoader;
import com.intel.cosbench.controller.loader.Formats;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class CSVSnapshotLoader
extends AbstractSnapshotLoader {
    private String[] name = null;
    private int opNum = 0;

    public CSVSnapshotLoader(BufferedReader reader, WorkloadInfo workloadContext, String stageId) throws IOException {
        super.init(reader, workloadContext, stageId);
    }

    @Override
    protected void readHeader() throws IOException {
        if (this.reader.readLine() == null) {
            return;
        }
        String workloadRecordLine = this.reader.readLine();
        String[] columns = workloadRecordLine.split(",");
        for (Work work : this.stageContext.getStage().getWorks()) {
            this.opNum += work.getOperations().size();
        }
        this.name = new String[this.opNum];
        int i = 0;
        while (i < this.opNum) {
            this.name[i] = columns[i + 1];
            ++i;
        }
    }

    @Override
    protected void readSnapshot() throws IOException {
        String workloadRecordLine = null;
        while ((workloadRecordLine = this.reader.readLine()) != null) {
            String[] columns = workloadRecordLine.split(",");
            Date timestamp = null;
            try {
                timestamp = Formats.TIME.parse(columns[0]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Snapshot snapshot = new Snapshot(this.loadReport(columns), timestamp);
            snapshot.setMinVersion(Integer.valueOf(columns[1 + this.opNum * 7]).intValue());
            snapshot.setVersion(Integer.valueOf(columns[2 + this.opNum * 7]).intValue());
            snapshot.setMaxVersion(Integer.valueOf(columns[3 + this.opNum * 7]).intValue());
            this.stageContext.getSnapshotRegistry().addItem((Object)snapshot);
        }
    }

    private Report loadReport(String[] columns) {
        Report report = new Report();
        List<Metrics> metrics = this.loadMetrics(columns);
        for (Metrics metric : metrics) {
            report.addMetrics(metric);
        }
        return report;
    }

    private List<Metrics> loadMetrics(String[] columns) {
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        int i = 0;
        while (i < this.opNum) {
            Metrics metric = new Metrics();
            metric.setName(this.name[i]);
            int n = this.name[i].lastIndexOf("-");
            if (n > 0) {
                metric.setOpName(this.name[i].substring(0, n));
                metric.setSampleType(this.name[i].substring(n + 1));
            } else {
                metric.setOpName(this.name[i]);
                metric.setSampleType(this.name[i]);
            }
            metric.setSampleCount(Formats.getIntValue(columns[i + 1]));
            metric.setByteCount(Formats.getLongValue(columns[i + this.opNum + 1]));
            double rt = Formats.getDoubleValue(columns[i + this.opNum * 2 + 1]);
            metric.setAvgResTime(rt);
            double pt = Formats.getDoubleValue(columns[i + this.opNum * 3 + 1]);
            metric.setAvgXferTime(rt - pt);
            metric.setThroughput(Formats.getDoubleValue(columns[i + this.opNum * 4 + 1]));
            metric.setBandwidth(Formats.getDoubleValue(columns[i + this.opNum * 5 + 1]));
            this.setRatio(columns[i + this.opNum * 6 + 1], metric);
            metrics.add(metric);
            ++i;
        }
        return metrics;
    }

    private void setRatio(String column, Metrics metrics) {
        if (!column.equalsIgnoreCase("N/A")) {
            metrics.setRatio(Double.valueOf(column.substring(0, column.length() - 1)) / 100.0);
            metrics.setTotalSampleCount((double)metrics.getSampleCount() / metrics.getRatio() > 2.147483647E9 ? Integer.MAX_VALUE : (int)((double)metrics.getSampleCount() / metrics.getRatio()));
        } else {
            metrics.setRatio(0.0);
            metrics.setTotalSampleCount(0);
        }
    }
}

