/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.loader;

import com.intel.cosbench.bench.Report;
import com.intel.cosbench.config.Workload;
import com.intel.cosbench.controller.loader.AbstractRunLoader;
import com.intel.cosbench.controller.loader.Formats;
import com.intel.cosbench.controller.model.WorkloadContext;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.model.WorkloadState;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class CSVRunLoader
extends AbstractRunLoader {
    private List<WorkloadInfo> workloads = new ArrayList<WorkloadInfo>();

    public CSVRunLoader(BufferedReader reader) throws IOException {
        super.init(reader);
    }

    @Override
    protected void readHeader() throws IOException {
        this.reader.readLine();
    }

    @Override
    protected List<WorkloadInfo> readWorkload() throws IOException {
        String workloadRecordLine = null;
        while ((workloadRecordLine = this.reader.readLine()) != null) {
            String[] columns = workloadRecordLine.split(",");
            WorkloadContext workloadContext = new WorkloadContext();
            workloadContext.setArchived(true);
            workloadContext.setId(columns[0]);
            Report report = new Report();
            workloadContext.setReport(report);
            Workload workload = new Workload();
            workload.setName(columns[1]);
            workloadContext.setWorkload(workload);
            try {
                if (!columns[2].isEmpty()) {
                    workloadContext.setSubmitDate(Formats.DATETIME.parse(columns[2]));
                }
                if (!columns[3].isEmpty()) {
                    workloadContext.setStartDate(Formats.DATETIME.parse(columns[3]));
                }
                if (!columns[4].isEmpty()) {
                    workloadContext.setStopDate(Formats.DATETIME.parse(columns[4]));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            workloadContext.setOpInfo(columns[5].split(" "));
            WorkloadState[] workloadStateArray = WorkloadState.values();
            int n = workloadStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorkloadState state = workloadStateArray[n2];
                if (columns[6].equalsIgnoreCase(state.toString().toLowerCase())) {
                    workloadContext.setState(state);
                    break;
                }
                ++n2;
            }
            int index = 6;
            while (++index <= columns.length - 1) {
                String[] str = columns[index].split("@");
                String stateName = str[0].trim();
                Date stateDate = null;
                try {
                    if (str.length > 1) {
                        stateDate = Formats.DATETIME.parse(str[1].trim());
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                workloadContext.setState(stateName, stateDate);
            }
            this.workloads.add(workloadContext);
        }
        return this.workloads;
    }
}

