/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.archiver;

import com.intel.cosbench.config.Workload;
import com.intel.cosbench.config.WorkloadWriter;
import com.intel.cosbench.config.castor.CastorConfigTools;
import com.intel.cosbench.controller.archiver.WorkloadArchiver;
import com.intel.cosbench.exporter.Exporters;
import com.intel.cosbench.exporter.LatencyExporter;
import com.intel.cosbench.exporter.LogExporter;
import com.intel.cosbench.exporter.MatrixExporter;
import com.intel.cosbench.exporter.RunExporter;
import com.intel.cosbench.exporter.StageExporter;
import com.intel.cosbench.exporter.TaskExporter;
import com.intel.cosbench.exporter.WorkerExporter;
import com.intel.cosbench.exporter.WorkloadExporter;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.DriverInfo;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Scanner;

public class SimpleWorkloadArchiver
implements WorkloadArchiver {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private File ARCHIVE_DIR = new File("archive");

    public SimpleWorkloadArchiver() {
        this("archive");
    }

    public SimpleWorkloadArchiver(String archive) {
        this.ARCHIVE_DIR = new File(archive);
        if (!this.ARCHIVE_DIR.exists()) {
            this.ARCHIVE_DIR.mkdirs();
        }
        String path = this.ARCHIVE_DIR.getAbsolutePath();
        LOGGER.info("using {} for storing workload archives", (Object)path);
    }

    @Override
    public synchronized void archive(WorkloadInfo info) {
        File runDir = new File(this.ARCHIVE_DIR, SimpleWorkloadArchiver.getRunDirName(info));
        try {
            this.doArchive(info, runDir);
        }
        catch (Exception e) {
            LOGGER.error("fail to archive workload", (Throwable)e);
            return;
        }
        try {
            this.updateCount(info);
        }
        catch (Exception e) {
            LOGGER.error("fail to update count", (Throwable)e);
        }
        String id = info.getId();
        LOGGER.info("workload {} has been successfully archived", (Object)id);
    }

    private void doArchive(WorkloadInfo info, File runDir) throws IOException {
        this.exportWorkloadRun(info);
        runDir.mkdir();
        this.exportWorkload(info, runDir);
        this.exportLatency(info, runDir);
        StageInfo[] stageInfoArray = info.getStageInfos();
        int n = stageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StageInfo sInfo = stageInfoArray[n2];
            this.exportStage(sInfo, runDir);
            ++n2;
        }
        this.exportConfig(info.getWorkload(), runDir);
        this.exportLog(info, runDir);
        this.exportScriptsLog(info, runDir);
        this.exportPerformanceMatrix(info);
        this.exportTaskInfo(info, runDir);
        this.exportWorkerInfo(info, runDir);
    }

    private void exportWorkerInfo(WorkloadInfo info, File parent) throws IOException {
        StageInfo[] stageInfoArray = info.getStageInfos();
        int n = stageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StageInfo sInfo = stageInfoArray[n2];
            File file = new File(parent, String.valueOf(SimpleWorkloadArchiver.getStageFileName(sInfo)) + "-worker" + ".csv");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            WorkerExporter exporter = Exporters.newWorkExporter((StageInfo)sInfo);
            try {
                exporter.export((Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
            String name = String.valueOf(sInfo.getId()) + "worker";
            String path = file.getAbsolutePath();
            String msg = "perf details of {} has been exported to {}";
            LOGGER.debug(msg, (Object)name, (Object)path);
            ++n2;
        }
    }

    private void exportTaskInfo(WorkloadInfo info, File parent) throws IOException {
        DriverInfo[] driverInfoArray = info.getDriverInfos();
        int n = driverInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DriverInfo dInfo = driverInfoArray[n2];
            File file = new File(parent, String.valueOf(dInfo.getName()) + ".csv");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            TaskExporter exporter = Exporters.newTaskExporter((WorkloadInfo)info, (DriverInfo)dInfo);
            try {
                exporter.export((Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
            String name = dInfo.getName();
            String path = file.getAbsolutePath();
            String msg = "perf details of {} has been exported to {}";
            LOGGER.debug(msg, (Object)name, (Object)path);
            ++n2;
        }
    }

    private static String getRunDirName(WorkloadInfo info) {
        String name = info.getId();
        name = String.valueOf(name) + '-' + info.getWorkload().getName();
        return name;
    }

    private void exportWorkloadRun(WorkloadInfo info) throws IOException {
        File file = new File(this.ARCHIVE_DIR, "run-history.csv");
        boolean ready = file.exists() && file.length() > 0L;
        BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
        RunExporter exporter = Exporters.newRunExporter((WorkloadInfo)info);
        try {
            if (!ready) {
                exporter.init((Writer)writer);
            }
            exporter.export((Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
        String id = info.getId();
        String path = file.getAbsolutePath();
        String msg = "run item for workload {} has been added to {}";
        LOGGER.debug(msg, (Object)id, (Object)path);
    }

    private void exportWorkload(WorkloadInfo info, File parent) throws IOException {
        File file = new File(parent, String.valueOf(SimpleWorkloadArchiver.getWorkloadFileName(info)) + ".csv");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        WorkloadExporter exporter = Exporters.newWorkloadExporter((WorkloadInfo)info);
        try {
            exporter.export((Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
        String id = info.getId();
        String path = file.getAbsolutePath();
        String msg = "perf details of workload {} has been exported to {}";
        LOGGER.debug(msg, (Object)id, (Object)path);
    }

    private static String getWorkloadFileName(WorkloadInfo info) {
        String name = info.getId();
        name = String.valueOf(name) + "-" + info.getWorkload().getName();
        return name;
    }

    private void exportLatency(WorkloadInfo info, File parent) throws IOException {
        File file = new File(parent, String.valueOf(SimpleWorkloadArchiver.getLatencyFileName(info)) + ".csv");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        LatencyExporter exporter = Exporters.newLatencyExporter((WorkloadInfo)info);
        try {
            exporter.export((Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
        String id = info.getId();
        String path = file.getAbsolutePath();
        String msg = "latency details of workload {} has been exported to {}";
        LOGGER.debug(msg, (Object)id, (Object)path);
    }

    private static String getLatencyFileName(WorkloadInfo info) {
        String name = info.getId();
        name = String.valueOf(name) + "-" + info.getWorkload().getName();
        name = String.valueOf(name) + "-rt-histogram";
        return name;
    }

    private void exportStage(StageInfo info, File parent) throws IOException {
        File file = new File(parent, String.valueOf(SimpleWorkloadArchiver.getStageFileName(info)) + ".csv");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        StageExporter exporter = Exporters.newStageExporter((StageInfo)info);
        try {
            exporter.export((Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
        String id = info.getId();
        String path = file.getAbsolutePath();
        String msg = "perf details of stage {} has been exported to {}";
        LOGGER.debug(msg, (Object)id, (Object)path);
    }

    private static String getStageFileName(StageInfo info) {
        return info.getId();
    }

    private void exportConfig(Workload workload, File parent) throws IOException {
        File file = new File(parent, "workload-config.xml");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        WorkloadWriter ww = CastorConfigTools.getWorkloadWriter();
        try {
            writer.write(ww.toXmlString(workload));
        }
        finally {
            ((Writer)writer).close();
        }
        String name = workload.getName();
        String path = file.getAbsolutePath();
        String msg = "config xml for workload {} has been generated at {}";
        LOGGER.debug(msg, (Object)name, (Object)path);
    }

    @Override
    public File getWorkloadConfig(WorkloadInfo info) {
        File runDir = new File(this.ARCHIVE_DIR, SimpleWorkloadArchiver.getRunDirName(info));
        return new File(runDir, "workload-config.xml");
    }

    private void exportLog(WorkloadInfo info, File parent) throws IOException {
        File file = new File(parent, "workload.log");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        LogExporter exporter = Exporters.newLogExporter((WorkloadInfo)info);
        try {
            exporter.export((Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
        String id = info.getId();
        String path = file.getAbsolutePath();
        String msg = "driver logs for workload {} has been merged at {}";
        LOGGER.debug(msg, (Object)id, (Object)path);
    }

    private void exportScriptsLog(WorkloadInfo info, File parent) throws IOException {
        File file = new File(parent, "scripts.log");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        LogExporter exporter = Exporters.newScriptLogExporter((WorkloadInfo)info);
        try {
            exporter.export((Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
        String id = info.getId();
        String path = file.getAbsolutePath();
        String msg = "driver script logs for workload {} has been merged at {}";
        LOGGER.debug(msg, (Object)id, (Object)path);
    }

    @Override
    public File getWorkloadLog(WorkloadInfo info) {
        File runDir = new File(this.ARCHIVE_DIR, SimpleWorkloadArchiver.getRunDirName(info));
        return new File(runDir, "workload.log");
    }

    private void exportPerformanceMatrix(WorkloadInfo info) throws IOException {
        File file = new File(this.ARCHIVE_DIR, "workloads.csv");
        boolean ready = file.exists() && file.length() > 0L;
        BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
        MatrixExporter exporter = Exporters.newMatrixExporter((WorkloadInfo)info);
        try {
            if (!ready) {
                exporter.init((Writer)writer);
            }
            exporter.export((Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
        String id = info.getId();
        String path = file.getAbsolutePath();
        String msg = "perf details of workload {} has been added to {}";
        LOGGER.debug(msg, (Object)id, (Object)path);
    }

    private void updateCount(WorkloadInfo info) throws IOException {
        int count = 0;
        File file = new File(this.ARCHIVE_DIR, ".meta");
        String workloadId = null;
        workloadId = info.getId();
        try {
            count = this.parseID(workloadId);
        }
        catch (Exception e) {
            LOGGER.error("cannot parse workloadId", (Throwable)e);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            writer.write(String.valueOf(count));
        }
        finally {
            ((Writer)writer).close();
        }
        LOGGER.debug("workload count has been updated as {}", (Object)count);
    }

    @Override
    public synchronized int getTotalWorkloads() {
        int count = 0;
        try {
            count = this.retrieveCount();
        }
        catch (Exception e) {
            LOGGER.error("fail to retrieve workload count", (Throwable)e);
        }
        return count;
    }

    private int retrieveCount() throws IOException {
        int count;
        File file = new File(this.ARCHIVE_DIR, ".meta");
        if (!file.exists() || file.length() == 0L) {
            return 0;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            count = new Scanner(reader).nextInt();
        }
        finally {
            ((Reader)reader).close();
        }
        LOGGER.debug("workload count has been retrieved as {}", (Object)count);
        return count;
    }

    private int parseID(String workloadID) throws NumberFormatException, IndexOutOfBoundsException {
        int count = 0;
        try {
            count = Integer.parseInt(workloadID.substring(1));
        }
        catch (Exception e) {
            LOGGER.error("cannot extract count from workloadId", (Throwable)e);
        }
        return count;
    }
}

