/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.log.log4j;

import com.intel.cosbench.log.LogLevel;
import com.intel.cosbench.log.LogManager;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.log.log4j.Log4jLogger;
import com.intel.cosbench.log.log4j.Log4jUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.varia.NullAppender;

public class Log4jLogManager
implements LogManager {
    private static final int FILE_NUM = 10;
    private static final int FILE_SIZE = 0xA00000;
    private static final int BUFFER_SIZE = 10240;
    private File file;
    private Logger logger;
    private Hierarchy repository;
    private boolean fileAttached = false;
    private boolean consoleEnabled = false;

    public Log4jLogManager() {
        Level level = Level.INFO;
        RootLogger root = new RootLogger(level);
        this.repository = new Hierarchy((org.apache.log4j.Logger)root);
        root.addAppender((Appender)new NullAppender());
        this.logger = new Log4jLogger((org.apache.log4j.Logger)root);
    }

    @Override
    public void dispose() {
        this.repository.shutdown();
        this.repository = null;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public LogLevel getLogLevel() {
        Level level = this.repository.getRootLogger().getLevel();
        return Log4jUtils.fromLog4jLevel(level);
    }

    @Override
    public void setLogLevel(LogLevel level) {
        Level newLevel = Log4jUtils.toLog4jLevel(level);
        this.repository.getRootLogger().setLevel(newLevel);
        this.logger.debug("log level has been set to {}", level.name());
    }

    @Override
    public synchronized void setLogFile(File dir, String filename, boolean append, boolean buffer) throws IOException {
        if (!this.fileAttached) {
            this.file = new File(dir, filename);
            filename = this.file.getAbsolutePath();
            org.apache.log4j.Logger logger = this.repository.getRootLogger();
            FileAppender appender = Log4jLogManager.createFileAppender();
            appender.setFile(filename, append, buffer, 10240);
            logger.addAppender((Appender)appender);
            this.fileAttached = true;
            String path = this.file.getAbsolutePath();
            this.logger.info("will append log to file {}", path);
        } else {
            this.logger.debug("attempt to attach multiple log files");
        }
    }

    private static FileAppender createFileAppender() {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setName("FILE");
        appender.setLayout((Layout)new PatternLayout("%d [%p] [%C{1}] - %m%n"));
        appender.setMaximumFileSize(0xA00000L);
        appender.setMaxBackupIndex(10);
        return appender;
    }

    @Override
    public synchronized void enableConsole() {
        if (!this.consoleEnabled) {
            org.apache.log4j.Logger logger = this.repository.getRootLogger();
            ConsoleAppender appender = Log4jLogManager.createConsoleAppender();
            logger.addAppender((Appender)appender);
            this.consoleEnabled = true;
            this.logger.info("will append log to console");
        } else {
            this.logger.debug("attempt to attach multiple consoles");
        }
    }

    private static ConsoleAppender createConsoleAppender() {
        String target = "System.out";
        PatternLayout layout = new PatternLayout("(%F:%L)%n%d [%-15.15t] [%-5p] - %m%n");
        ConsoleAppender appender = new ConsoleAppender((Layout)layout, target);
        appender.setName("CONSOLE");
        return appender;
    }

    @Override
    public String getLogAsString() throws IOException {
        return FileUtils.readFileToString((File)this.file);
    }
}

