/*
 * Decompiled with CFR 0.152.
 */
package com.scality.cosbench.client;

import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.log.Logger;
import com.scality.cosbench.client.SproxydClientException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;

public class SproxydClient {
    public static final int DEFAULT_SO_TIMEOUT = 2000;
    private static final int DEFAULT_CHECK_PERIOD = 10000;
    private static Logger LOG = null;
    private HttpClient client;
    private SproxydUrlList urls;
    private final Map<Endpoint, SproxydEndpoint> endpoints = new HashMap<Endpoint, SproxydEndpoint>();
    private volatile HttpUriRequest request;

    public SproxydClient(HttpClient client, String hosts, int port, String basePath, Logger logger) {
        this.client = client;
        this.urls = new SproxydUrlList(hosts, port, basePath);
        this.urls.registerEndpoints(this.endpoints);
        LOG = logger;
    }

    public void dispose() {
        this.request = null;
    }

    public void abort() {
        if (this.request != null) {
            this.request.abort();
        }
        this.request = null;
    }

    public void createContainer(String container) throws IOException, SproxydClientException {
    }

    public void deleteContainer(String container) throws IOException, SproxydClientException {
    }

    public InputStream getObjectAsStream(String container, String object) throws IOException, SproxydClientException {
        HttpResponse response = null;
        int code = 200;
        SproxydUrl base = this.urls.getNext();
        try {
            String url = String.format("%s%s/%s", base, container, object);
            HttpGet get = HttpClientUtil.makeHttpGet((String)url);
            this.request = get;
            response = this.client.execute((HttpUriRequest)get);
            StatusLine statusLine = response.getStatusLine();
            code = statusLine.getStatusCode();
            if (code == 200) {
                InputStream content = response.getEntity().getContent();
                response = null;
                InputStream inputStream = content;
                return inputStream;
            }
            if (code == 404) {
                InputStream content = response.getEntity().getContent();
                response = null;
                InputStream inputStream = content;
                return inputStream;
            }
        }
        catch (IOException exc) {
            base.exclude(exc.getMessage());
            throw exc;
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        throw new SproxydClientException(code, "failed to read object");
    }

    public void storeStreamedObject(String container, String object, InputStream data, long length) throws IOException, SproxydClientException {
        HttpResponse response = null;
        int code = 200;
        SproxydUrl base = this.urls.getNext();
        int trials = 3;
        while (trials > 0) {
            try {
                try {
                    String url = String.format("%s%s/%s", base, container, object);
                    HttpPut put = HttpClientUtil.makeHttpPut((String)url);
                    this.request = put;
                    InputStreamEntity entity = new InputStreamEntity(data, length);
                    entity.setContentType("application/octet-stream");
                    if (length < 0L) {
                        entity.setChunked(true);
                    }
                    put.setEntity((HttpEntity)entity);
                    response = this.client.execute((HttpUriRequest)put);
                    StatusLine statusLine = response.getStatusLine();
                    code = statusLine.getStatusCode();
                }
                catch (IOException exc) {
                    base.exclude(exc.getMessage());
                    throw exc;
                }
            }
            finally {
                if (response != null) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            if (code != 500 && code != 423) break;
            Header[] retryAllowed = response.getHeaders("X-Scal-Retry-Allowed");
            if (code == 500 && retryAllowed.length > 0 && retryAllowed[0].equals("No")) break;
            if (code == 423) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new SproxydClientException(code, e.getLocalizedMessage());
                }
            }
            --trials;
        }
        if (code != 201 && code != 200) {
            throw new SproxydClientException(code, "failed to put object");
        }
    }

    public void deleteObject(String container, String object) throws IOException, SproxydClientException {
        HttpResponse response = null;
        int code = 200;
        SproxydUrl base = this.urls.getNext();
        try {
            try {
                String url = String.format("%s%s/%s", base, container, object);
                HttpDelete delete = HttpClientUtil.makeHttpDelete((String)url);
                this.request = delete;
                response = this.client.execute((HttpUriRequest)delete);
                StatusLine statusLine = response.getStatusLine();
                code = statusLine.getStatusCode();
            }
            catch (IOException exc) {
                base.exclude(exc.getMessage());
                throw exc;
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        if (code != 200) {
            throw new SproxydClientException(code, "failed to delete object");
        }
    }

    private static void info(String format, Object arg) {
        if (LOG != null) {
            LOG.info(format, arg);
        }
    }

    private static void warn(String format, Object arg) {
        if (LOG != null) {
            LOG.warn(format, arg);
        }
    }

    private static void warn(String format, Object arg1, Object arg2) {
        if (LOG != null) {
            LOG.warn(format, arg1, arg2);
        }
    }

    private static class Endpoint {
        private final String host;
        private final int port;

        Endpoint(URI uri) {
            this.host = uri.getHost();
            this.port = uri.getPort();
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public int hashCode() {
            return this.getHost().hashCode() + this.getPort();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint other = (Endpoint)obj;
                return this.getPort() == other.getPort() && this.getHost().equals(other.getHost());
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.getHost()) + ":" + this.getPort();
        }
    }

    private static class SproxydEndpoint
    extends Thread {
        private static int id = 0;
        private static int checkPeriod = 10000;
        private final URI uri;
        private HttpClient client;
        private boolean isUp;
        private volatile boolean shutdownRequested = false;

        SproxydEndpoint(URI uri) {
            this.uri = uri;
            this.client = HttpClientUtil.createHttpClient((int)300);
            this.setName(String.format("ScalConnChecker-%d", id++));
            this.setDaemon(true);
            this.isUp = true;
        }

        public synchronized boolean isUp() {
            return this.isUp;
        }

        public synchronized boolean setUp(boolean isUp) {
            boolean before = this.isUp;
            this.isUp = isUp;
            return before;
        }

        private void update(boolean isUp, String message) {
            boolean wasUp = this.setUp(isUp);
            if (wasUp && !isUp) {
                SproxydClient.warn("Blacklisting {}, {}", this.uri, message);
            } else if (!wasUp) {
                if (isUp) {
                    SproxydClient.warn("{} is up", this.uri);
                } else {
                    SproxydClient.warn("{} still down", this.uri);
                }
            }
        }

        public void exclude(String message) {
            this.update(false, message);
        }

        public void include() {
            this.update(true, "");
        }

        public void retryConnection() {
            if (this.isUp()) {
                return;
            }
            SproxydClient.info("Checking connection to {}", this.uri.toString());
            HttpResponse response = null;
            HttpGet get = HttpClientUtil.makeHttpGet((String)(String.valueOf(this.uri.toString()) + ".conf"));
            try {
                response = this.client.execute((HttpUriRequest)get);
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode == 200) {
                    this.include();
                } else if (statusCode >= 500) {
                    this.exclude(statusLine.getReasonPhrase());
                }
            }
            catch (Exception e) {
                this.exclude(e.getMessage());
            }
        }

        public void shutdown() {
            this.shutdownRequested = true;
            this.interrupt();
        }

        @Override
        public void run() {
            SproxydClient.info("{} thread starting", this.getName());
            while (!this.shutdownRequested) {
                this.retryConnection();
                try {
                    Thread.sleep(checkPeriod);
                }
                catch (InterruptedException interruptedException) {}
            }
            SproxydClient.info("{} thread exiting", this.getName());
        }
    }

    static class SproxydUrl {
        private final URI uri;
        private SproxydEndpoint endpoint;

        SproxydUrl(String url) throws URISyntaxException {
            if (!url.endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            this.uri = new URI(url);
        }

        public boolean isUp() {
            return this.endpoint.isUp();
        }

        public void exclude(String message) {
            this.endpoint.exclude(message);
        }

        public void registerEndpoint(Map<Endpoint, SproxydEndpoint> endpoints) {
            Endpoint key = new Endpoint(this.uri);
            if (endpoints.containsKey(key)) {
                this.endpoint = endpoints.get(key);
            } else {
                this.endpoint = new SproxydEndpoint(this.uri);
                endpoints.put(key, this.endpoint);
            }
        }

        public String toString() {
            return this.uri.toString();
        }
    }

    private static class SproxydUrlList {
        private SproxydUrl[] urls;
        private int current = 0;

        SproxydUrlList(String hosts, int port, String basePath) {
            String[] hostList = hosts.split(",");
            this.urls = new SproxydUrl[hostList.length];
            int i = 0;
            while (i < hostList.length) {
                try {
                    this.urls[i] = new SproxydUrl(String.format("http://%s:%d%s", hostList[i], port, basePath));
                }
                catch (URISyntaxException uRISyntaxException) {}
                ++i;
            }
        }

        void registerEndpoints(Map<Endpoint, SproxydEndpoint> endpoints) {
            SproxydUrl[] sproxydUrlArray = this.urls;
            int n = this.urls.length;
            int n2 = 0;
            while (n2 < n) {
                SproxydUrl url = sproxydUrlArray[n2];
                url.registerEndpoint(endpoints);
                ++n2;
            }
        }

        synchronized SproxydUrl getNext() throws SproxydClientException {
            int trials = this.urls.length;
            while (trials > 0) {
                this.current = (this.current + 1) % this.urls.length;
                SproxydUrl url = this.urls[this.current];
                if (url.isUp()) {
                    return url;
                }
                --trials;
            }
            throw new SproxydClientException(0, "All servers are blacklisted");
        }

        public String toString() {
            return Arrays.toString(this.urls);
        }
    }
}

