/*
 * Decompiled with CFR 0.152.
 */
package com.scality.cosbench.api;

import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.api.storage.StorageTimeoutException;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.log.Logger;
import com.scality.cosbench.client.SproxydClient;
import com.scality.cosbench.client.SproxydClientException;
import com.scality.cosbench.client.SproxydConstants;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class SproxydStorage
extends NoneStorage {
    private static HttpClient httpClient;
    private static int nbClients;
    private SproxydClient client;
    private String basePath;
    private String hosts;
    private int port;
    private int timeout;
    private int maxTotal;
    private int maxPerRoute;
    private boolean logging;

    static {
        nbClients = 0;
    }

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.initParms(config);
        HttpClient httpClient = SproxydStorage.createHttpClient(this.timeout, this.maxTotal, this.maxPerRoute);
        this.client = new SproxydClient(httpClient, this.hosts, this.port, this.basePath, (Logger)(this.logging ? logger : null));
        logger.debug("sproxyd client has been initialized");
    }

    private static synchronized HttpClient createHttpClient(int timeout, int maxTotal, int maxPerRoute) {
        if (httpClient == null) {
            ThreadSafeClientConnManager tscm = new ThreadSafeClientConnManager();
            tscm.setMaxTotal(maxTotal);
            tscm.setDefaultMaxPerRoute(maxPerRoute);
            HttpParams params = SproxydStorage.createDefaultHttpParams(timeout);
            httpClient = new DefaultHttpClient((ClientConnectionManager)tscm, params);
        }
        ++nbClients;
        return httpClient;
    }

    private static synchronized void disposeHttpClient() {
        if (--nbClients == 0) {
            httpClient.getConnectionManager().shutdown();
            httpClient = null;
        }
    }

    private static HttpParams createDefaultHttpParams(int timeout) {
        BasicHttpParams params = new BasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams((HttpParams)params);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"cosbench/2.0");
        return params;
    }

    private void initParms(Config config) {
        this.basePath = config.get("base_path", "/proxy/chord");
        this.hosts = config.get("hosts", "127.0.0.1");
        this.port = config.getInt("port", 81);
        this.timeout = config.getInt("timeout", 30000);
        this.logging = config.getBoolean("logging", SproxydConstants.LOGGING_DEFAULT.booleanValue());
        String[] poolSize = config.get("pool_size", "60,10").split(",");
        try {
            this.maxTotal = Integer.parseInt(poolSize[0]);
            this.maxPerRoute = poolSize.length > 1 ? Integer.parseInt(poolSize[1]) : 2;
        }
        catch (NumberFormatException exc) {
            throw new ConfigException("Invalid pool size, must be <int>,<int> or <int>", (Throwable)exc);
        }
        this.parms.put("logging", (Object)this.logging);
        this.parms.put("timeout", (Object)this.timeout);
        this.logger.debug("using storage config: {}", (Object)this.parms);
    }

    public void dispose() {
        super.dispose();
        this.client.dispose();
        SproxydStorage.disposeHttpClient();
    }

    public void abort() {
        super.abort();
        this.client.abort();
    }

    public InputStream getObject(String container, String object, Config config) {
        InputStream stream;
        super.getObject(container, object, config);
        try {
            stream = this.client.getObjectAsStream(container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SproxydClientException se) {
            String msg = se.getMessage();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        return stream;
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        try {
            this.client.createContainer(container);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SproxydClientException se) {
            String msg = se.getMessage();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        try {
            this.client.storeStreamedObject(container, object, data, length);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SproxydClientException se) {
            String msg = se.getMessage();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        try {
            this.client.deleteContainer(container);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SproxydClientException se) {
            String msg = se.getMessage();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        try {
            this.client.deleteObject(container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SproxydClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }
}

