/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.service;

import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.common.INIConfigParser;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.LogLevel;
import com.intel.cosbench.log.LogManager;
import com.intel.cosbench.log.Logger;
import java.io.File;
import java.io.IOException;

public abstract class AbstractServiceFactory {
    private static Logger logger = LogFactory.getSystemLogger();
    protected Config config;

    protected abstract String getConfigFile();

    protected abstract String getServiceName();

    public void init() throws Exception {
        String path = this.getConfigFile();
        File file = new File(path);
        if (file.exists()) {
            this.loadConfig(file);
        } else {
            this.config = INIConfigParser.getEmptyConfig();
        }
        this.initLogSystem();
    }

    private void loadConfig(File file) {
        String service = this.getServiceName();
        try {
            this.config = INIConfigParser.parse((File)file);
        }
        catch (ConfigException e) {
            String msg = "cannot load " + service + " configuration";
            throw new ConfigException(msg, (Throwable)e);
        }
        String path = file.getAbsolutePath();
        logger.info("use " + service + " configuration defined in {}", (Object)path);
    }

    protected void initLogSystem() throws IOException {
        LogManager manager = LogFactory.getSystemLogManager();
        String level = this.loadLogLevel();
        manager.setLogLevel(LogLevel.parseLevel((String)level));
        String filename = this.loadLogFile();
        File file = new File(filename);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        boolean append = true;
        boolean buffer = false;
        manager.setLogFile(dir, file.getName(), append, buffer);
    }

    protected String loadLogLevel() {
        return this.config.get("log_level", "INFO");
    }

    protected String loadLogFile() {
        return this.config.get("log_file", "log/system.log");
    }
}

