/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.exporter.LogExporter;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.TaskInfo;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.IOException;
import java.io.Writer;

class SimpleLogExporter
implements LogExporter {
    private WorkloadInfo workload;

    public void setWorkload(WorkloadInfo workload) {
        this.workload = workload;
    }

    @Override
    public void export(Writer writer) throws IOException {
        StageInfo[] stageInfoArray = this.workload.getStageInfos();
        int n = stageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StageInfo stage = stageInfoArray[n2];
            this.exportStageLog(writer, stage);
            ++n2;
        }
        writer.flush();
    }

    private void exportStageLog(Writer writer, StageInfo stage) throws IOException {
        writer.write("=========================");
        writer.write("=========================");
        writer.write(" stage: " + stage.getId() + ' ');
        writer.write("=========================");
        writer.write("=========================");
        writer.write(10);
        TaskInfo[] taskInfoArray = stage.getTaskInfos();
        int n = taskInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskInfo task = taskInfoArray[n2];
            this.exportTaskLog(writer, task);
            ++n2;
        }
        writer.flush();
    }

    private void exportTaskLog(Writer writer, TaskInfo task) throws IOException {
        writer.write("-----------------");
        writer.write("-----------------");
        writer.write(this.getTaskLogHeader(task));
        writer.write("-----------------");
        writer.write("-----------------");
        writer.write(10);
        writer.write(task.getLog());
    }

    private String getTaskLogHeader(TaskInfo task) {
        String header = " mission: " + task.getMissionId();
        String driver = task.getSchedule().getDriver().getName();
        header = String.valueOf(header) + ", driver: " + driver + ' ';
        return header;
    }
}

