/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.exporter.LogExporter;
import com.intel.cosbench.model.DriverInfo;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ScriptsLogExporter
implements LogExporter {
    private WorkloadInfo workload;

    public void setWorkload(WorkloadInfo workload) {
        this.workload = workload;
    }

    @Override
    public void export(Writer writer) throws IOException {
        this.exportWorkloadLog(writer);
        StageInfo[] stageInfoArray = this.workload.getStageInfos();
        int n = stageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StageInfo stage = stageInfoArray[n2];
            this.exportStageLog(writer, stage);
            ++n2;
        }
        writer.flush();
    }

    private void exportWorkloadLog(Writer writer) throws IOException {
        writer.write("=========================");
        writer.write("=========================");
        writer.write(" workload level ");
        writer.write("=========================");
        writer.write("=========================");
        writer.write(10);
        String wsId = this.workload.getId();
        this.doExportLog(writer, wsId);
        writer.flush();
    }

    private void doExportLog(Writer writer, String wsId) throws IOException {
        DriverInfo[] driverInfoArray = this.workload.getDriverInfos();
        int n = driverInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DriverInfo driver = driverInfoArray[n2];
            Map<String, String> logMap = driver.getLogMap();
            if (logMap.containsKey(wsId)) {
                this.exportScriptLog(writer, logMap.get(wsId), driver.getName());
            }
            ++n2;
        }
    }

    private void exportStageLog(Writer writer, StageInfo stage) throws IOException {
        writer.write("=========================");
        writer.write("=========================");
        writer.write(" stage: " + stage.getId() + ' ');
        writer.write("=========================");
        writer.write("=========================");
        writer.write(10);
        String wsId = String.valueOf(this.workload.getId()) + stage.getId();
        this.doExportLog(writer, wsId);
        writer.flush();
    }

    private void exportScriptLog(Writer writer, String logCtx, String driver) throws IOException {
        int idx = StringUtils.indexOf((String)logCtx, (String)";");
        if (idx < 0 || idx + 1 == logCtx.length()) {
            return;
        }
        String scriptName = StringUtils.left((String)logCtx, (int)idx);
        String log = StringUtils.substring((String)logCtx, (int)(idx + 1));
        writer.write("-----------------");
        writer.write("-----------------");
        writer.write(" driver: " + driver + "  script: " + scriptName + ' ');
        writer.write("-----------------");
        writer.write("-----------------");
        writer.write(10);
        writer.write(log);
    }
}

