/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Histogram;
import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.exporter.AbstractWorkloadExporter;
import com.intel.cosbench.exporter.Formats;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.StateInfo;
import java.io.IOException;
import java.io.Writer;

class CSVWorkloadExporter
extends AbstractWorkloadExporter {
    CSVWorkloadExporter() {
    }

    @Override
    protected void writeHeader(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Stage").append(',');
        buffer.append("Op-Name").append(',');
        buffer.append("Op-Type").append(',');
        buffer.append("Op-Count").append(',');
        buffer.append("Byte-Count").append(',');
        buffer.append("Avg-ResTime").append(',');
        buffer.append("Avg-ProcTime").append(',');
        buffer.append("60%-ResTime").append(',');
        buffer.append("80%-ResTime").append(',');
        buffer.append("90%-ResTime").append(',');
        buffer.append("95%-ResTime").append(',');
        buffer.append("99%-ResTime").append(',');
        buffer.append("100%-ResTime").append(',');
        buffer.append("Throughput").append(',');
        buffer.append("Bandwidth").append(',');
        buffer.append("Succ-Ratio").append(',');
        buffer.append("Status").append(',');
        buffer.append("Detailed Status").append('\n');
        writer.write(buffer.toString());
    }

    @Override
    protected void writeMetrics(Writer writer, Metrics metrics, StageInfo stage) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(stage.getId()).append(',');
        String opt = metrics.getOpName();
        String spt = metrics.getSampleType();
        if (spt.equals(opt)) {
            buffer.append(opt);
        } else {
            buffer.append(String.valueOf(opt) + '-' + spt);
        }
        buffer.append(',');
        buffer.append(metrics.getOpType()).append(',');
        buffer.append(metrics.getSampleCount()).append(',');
        buffer.append(metrics.getByteCount()).append(',');
        double r = metrics.getAvgResTime();
        if (r > 0.0) {
            buffer.append(Formats.NUM.format(r));
        } else {
            buffer.append("N/A");
        }
        buffer.append(',');
        double pt = r - metrics.getAvgXferTime();
        if (pt > 0.0) {
            buffer.append(Formats.NUM.format(pt));
        } else {
            buffer.append("N/A");
        }
        buffer.append(',');
        CSVWorkloadExporter.writeLatencyInfo(buffer, metrics.getLatency());
        buffer.append(Formats.NUM.format(metrics.getThroughput())).append(',');
        buffer.append(Formats.NUM.format(metrics.getBandwidth())).append(',');
        double t = metrics.getRatio();
        if (t > 0.0) {
            buffer.append(Formats.RATIO.format(metrics.getRatio())).append(',');
        } else {
            buffer.append("N/A").append(',');
        }
        buffer.append(stage.getState().name().toLowerCase()).append(',');
        StateInfo[] stateInfoArray = stage.getStateHistory();
        int n = stateInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StateInfo state = stateInfoArray[n2];
            buffer.append(String.valueOf(state.getName().toLowerCase()) + " @ " + Formats.DATETIME.format(state.getDate())).append(',');
            ++n2;
        }
        buffer.setCharAt(buffer.length() - 1, '\n');
        writer.write(buffer.toString());
    }

    @Override
    protected void writeMetrics(Writer writer, StageInfo stage) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(stage.getStage().getName()).append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append("N/A").append(',');
        buffer.append(stage.getState().name().toLowerCase()).append(',');
        StateInfo[] stateInfoArray = stage.getStateHistory();
        int n = stateInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StateInfo state = stateInfoArray[n2];
            buffer.append(String.valueOf(state.getName().toLowerCase()) + " @ " + Formats.DATETIME.format(state.getDate())).append(',');
            ++n2;
        }
        buffer.setCharAt(buffer.length() - 1, '\n');
        writer.write(buffer.toString());
    }

    private static void writeLatencyInfo(StringBuilder buffer, Histogram latency) throws IOException {
        if (latency == null) {
            CSVWorkloadExporter.writePercentileRT(buffer, null);
            CSVWorkloadExporter.writePercentileRT(buffer, null);
            CSVWorkloadExporter.writePercentileRT(buffer, null);
            CSVWorkloadExporter.writePercentileRT(buffer, null);
            CSVWorkloadExporter.writePercentileRT(buffer, null);
            CSVWorkloadExporter.writePercentileRT(buffer, null);
        } else {
            CSVWorkloadExporter.writePercentileRT(buffer, latency.get_60());
            CSVWorkloadExporter.writePercentileRT(buffer, latency.get_80());
            CSVWorkloadExporter.writePercentileRT(buffer, latency.get_90());
            CSVWorkloadExporter.writePercentileRT(buffer, latency.get_95());
            CSVWorkloadExporter.writePercentileRT(buffer, latency.get_99());
            CSVWorkloadExporter.writePercentileRT(buffer, latency.get_100());
        }
    }

    private static void writePercentileRT(StringBuilder buffer, long[] resTime) {
        if (resTime == null) {
            buffer.append("N/A");
        } else {
            buffer.append(resTime[1]);
        }
        buffer.append(',');
    }
}

