/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.exporter.AbstractWorkerExporter;
import com.intel.cosbench.exporter.Formats;
import java.io.IOException;
import java.io.Writer;

public class CSVWorkerExporter
extends AbstractWorkerExporter {
    @Override
    protected void writeHeader(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        char[] cfr_ignored_0 = new char[8];
        buffer.append("Op-Type").append(',');
        buffer.append("Sample-Type").append(',');
        buffer.append("Op-Count").append(',');
        buffer.append("Byte-Count").append(',');
        buffer.append("Avg-ResTime").append(',');
        buffer.append("Avg-ProcTime").append(',');
        buffer.append("Throughput").append(',');
        buffer.append("Bandwidth").append(',');
        buffer.append("Succ-Ratio").append('\n');
        writer.write(buffer.toString());
    }

    @Override
    protected void writeMetrics(Writer writer, Metrics metrics) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(metrics.getOpType()).append(',');
        buffer.append(metrics.getSampleType()).append(',');
        buffer.append(metrics.getSampleCount()).append(',');
        buffer.append(metrics.getByteCount()).append(',');
        double r = metrics.getAvgResTime();
        if (r > 0.0) {
            buffer.append(Formats.NUM.format(r));
        } else {
            buffer.append("N/A");
        }
        buffer.append(',');
        double pt = metrics.getAvgResTime() - metrics.getAvgXferTime();
        if (pt > 0.0) {
            buffer.append(Formats.NUM.format(pt));
        } else {
            buffer.append("N/A");
        }
        buffer.append(',');
        buffer.append(Formats.NUM.format(metrics.getThroughput())).append(',');
        buffer.append(Formats.NUM.format(metrics.getBandwidth())).append(',');
        double t = metrics.getRatio();
        if (t > 0.0) {
            buffer.append(Formats.RATIO.format(metrics.getRatio()));
        } else {
            buffer.append("N/A");
        }
        buffer.append('\n');
        writer.write(buffer.toString());
    }
}

