/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.TaskReport;
import com.intel.cosbench.exporter.AbstractTaskExporter;
import com.intel.cosbench.exporter.Formats;
import java.io.IOException;
import java.io.Writer;

public class CSVTaskExporter
extends AbstractTaskExporter {
    @Override
    protected void writeHeader(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        char[] cfr_ignored_0 = new char[8];
        buffer.append("Op-Type").append(',');
        buffer.append("Sample-Type").append(',');
        buffer.append("Op-Count").append(',');
        buffer.append("Byte-Count").append(',');
        buffer.append("Avg-ResTime").append(',');
        buffer.append("Avg-ProcTime").append(',');
        buffer.append("Throughput").append(',');
        buffer.append("Bandwidth").append(',');
        buffer.append("Succ-Ratio").append('\n');
        writer.write(buffer.toString());
    }

    @Override
    protected void writeMetrics(Writer writer, TaskReport tReport) throws IOException {
        StringBuilder buffer = new StringBuilder();
        Report report = tReport.getReport();
        for (Metrics metrics : report) {
            buffer.append(metrics.getOpType()).append(',');
        }
        for (Metrics metrics : report) {
            buffer.append(metrics.getSampleType()).append(',');
        }
        for (Metrics metrics : report) {
            buffer.append(metrics.getSampleCount()).append(',');
        }
        for (Metrics metrics : report) {
            buffer.append(metrics.getByteCount()).append(',');
        }
        for (Metrics metrics : report) {
            double r = metrics.getAvgResTime();
            if (r > 0.0) {
                buffer.append(Formats.NUM.format(r));
            } else {
                buffer.append("N/A");
            }
            buffer.append(',');
        }
        for (Metrics metrics : report) {
            double pt = metrics.getAvgResTime() - metrics.getAvgXferTime();
            if (pt > 0.0) {
                buffer.append(Formats.NUM.format(pt));
            } else {
                buffer.append("N/A");
            }
            buffer.append(',');
        }
        for (Metrics metrics : report) {
            buffer.append(Formats.NUM.format(metrics.getThroughput())).append(',');
        }
        for (Metrics metrics : report) {
            buffer.append(Formats.NUM.format(metrics.getBandwidth())).append(',');
        }
        for (Metrics metrics : report) {
            double t = metrics.getRatio();
            if (t > 0.0) {
                buffer.append(Formats.RATIO.format(metrics.getRatio()));
            } else {
                buffer.append("N/A");
            }
            buffer.append('\n');
        }
        writer.write(buffer.toString());
    }
}

