/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.Snapshot;
import com.intel.cosbench.exporter.AbstractStageExporter;
import com.intel.cosbench.exporter.Formats;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

class CSVStageExporter
extends AbstractStageExporter {
    @Override
    protected void writeHeader(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Timestamp").append(',');
        char[] cs = new char[this.numOpTypes];
        Arrays.fill(cs, ',');
        String suffix = new String(cs);
        buffer.append("Op-Count").append(suffix);
        buffer.append("Byte-Count").append(suffix);
        buffer.append("Avg-ResTime").append(suffix);
        buffer.append("Avg-ProcTime").append(suffix);
        buffer.append("Throughput").append(suffix);
        buffer.append("Bandwidth").append(suffix);
        buffer.append("Succ-Ratio").append(suffix);
        buffer.append("Version-Info");
        buffer.append(',').append(',').append('\n').append(',');
        int i = 0;
        while (i < 7) {
            for (Metrics metrics : this.snapshots[0].getReport()) {
                buffer.append(StringUtils.join((Object[])new Object[]{metrics.getOpName().equals(metrics.getSampleType()) ? null : String.valueOf(metrics.getOpName()) + "-", metrics.getSampleType()})).append(',');
            }
            ++i;
        }
        buffer.append("Min-Version").append(',');
        buffer.append("Version").append(',');
        buffer.append("Max-Version").append('\n');
        writer.write(buffer.toString());
    }

    @Override
    protected void writeMetrics(Writer writer, Snapshot snapshot) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Formats.TIME.format(snapshot.getTimestamp())).append(',');
        Report report = snapshot.getReport();
        if (report.getSize() == 0) {
            report.addMetrics(Metrics.newMetrics("na.na"));
        }
        for (Metrics metrics : report) {
            buffer.append(metrics.getSampleCount()).append(',');
        }
        for (Metrics metrics : report) {
            buffer.append(metrics.getByteCount()).append(',');
        }
        for (Metrics metrics : report) {
            double r = metrics.getAvgResTime();
            if (r > 0.0) {
                buffer.append(Formats.NUM.format(r));
            } else {
                buffer.append("N/A");
            }
            buffer.append(',');
        }
        for (Metrics metrics : report) {
            double pt = metrics.getAvgResTime() - metrics.getAvgXferTime();
            if (pt > 0.0) {
                buffer.append(Formats.NUM.format(pt));
            } else {
                buffer.append("N/A");
            }
            buffer.append(',');
        }
        for (Metrics metrics : report) {
            buffer.append(Formats.NUM.format(metrics.getThroughput())).append(',');
        }
        for (Metrics metrics : report) {
            buffer.append(Formats.NUM.format(metrics.getBandwidth())).append(',');
        }
        for (Metrics metrics : report) {
            double t = metrics.getRatio();
            if (t > 0.0) {
                buffer.append(Formats.RATIO.format(metrics.getRatio()));
            } else {
                buffer.append("N/A");
            }
            buffer.append(',');
        }
        buffer.append(snapshot.getMinVersion()).append(',');
        buffer.append(snapshot.getVersion()).append(',');
        buffer.append(snapshot.getMaxVersion()).append('\n');
        writer.write(buffer.toString());
    }
}

