/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.exporter.AbstractRunExporter;
import com.intel.cosbench.exporter.Formats;
import com.intel.cosbench.model.StateInfo;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.model.WorkloadState;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;

class CSVRunExporter
extends AbstractRunExporter {
    @Override
    protected void writeHeader(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Id").append(',');
        buffer.append("Name").append(',');
        buffer.append("Submitted-At").append(',');
        buffer.append("Started-At").append(',');
        buffer.append("Stopped-At").append(',');
        buffer.append("Op-Info").append(',');
        buffer.append("State").append(',');
        buffer.append("Detailed State").append('\n');
        writer.write(buffer.toString());
    }

    @Override
    protected void writeWorkload(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.workload.getId()).append(',');
        buffer.append(this.workload.getWorkload().getName()).append(',');
        CSVRunExporter.appendDate(buffer, this.workload.getSubmitDate());
        CSVRunExporter.appendDate(buffer, this.workload.getStartDate());
        CSVRunExporter.appendDate(buffer, this.workload.getStopDate());
        CSVRunExporter.appendOperations(buffer, this.workload.getAllOperations());
        CSVRunExporter.appendState(buffer, this.workload.getState());
        CSVRunExporter.appendDetailedState(buffer, this.workload);
        buffer.setCharAt(buffer.length() - 1, '\n');
        writer.write(buffer.toString());
    }

    private static void appendDetailedState(StringBuilder buffer, WorkloadInfo workload) {
        StateInfo[] stateInfoArray = workload.getStateHistory();
        int n = stateInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StateInfo state = stateInfoArray[n2];
            String detailedState = String.valueOf(state.getName().toLowerCase()) + " @ " + Formats.DATETIME.format(state.getDate());
            buffer.append(detailedState).append(',');
            ++n2;
        }
    }

    private static void appendDate(StringBuilder buffer, Date date) {
        if (date != null) {
            buffer.append(Formats.DATETIME.format(date));
        }
        buffer.append(',');
    }

    private static void appendOperations(StringBuilder buffer, String[] ops) {
        String[] stringArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            buffer.append(op).append(' ');
            ++n2;
        }
        if (buffer.charAt(buffer.length() - 1) == ' ') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append(',');
    }

    private static void appendState(StringBuilder buffer, WorkloadState state) {
        buffer.append(state.toString().toLowerCase()).append(',');
    }
}

