/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Histogram;
import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.config.Operation;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.exporter.AbstractMatrixExporter;
import com.intel.cosbench.exporter.Formats;
import com.intel.cosbench.model.StageInfo;
import java.io.IOException;
import java.io.Writer;

class CSVMatrixExporter
extends AbstractMatrixExporter {
    CSVMatrixExporter() {
    }

    @Override
    protected void writeHeader(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Id").append(',');
        buffer.append("Op-Name").append(',');
        buffer.append("Op-Count").append(',');
        buffer.append("Byte-Count").append(',');
        buffer.append("Worker-Count").append(',');
        buffer.append("Avg-ResTime").append(',');
        buffer.append("Avg-ProcTime").append(',');
        buffer.append("60%-ResTime").append(',');
        buffer.append("80%-ResTime").append(',');
        buffer.append("90%-ResTime").append(',');
        buffer.append("95%-ResTime").append(',');
        buffer.append("99%-ResTime").append(',');
        buffer.append("100%-ResTime").append(',');
        buffer.append("Throughput").append(',');
        buffer.append("Bandwidth").append(',');
        buffer.append("Succ-Ratio").append(',');
        buffer.append("Config-Info").append('\n');
        writer.write(buffer.toString());
    }

    @Override
    protected void writeMetrics(Writer writer, StageInfo stage, Metrics metrics, int idx) throws IOException {
        StringBuilder buffer = new StringBuilder();
        String uuid = String.valueOf(this.workload.getId()) + '-' + stage.getId() + '-' + idx;
        buffer.append(uuid).append(',');
        String opt = metrics.getOpName();
        String spt = metrics.getSampleType();
        if (spt.equals(opt)) {
            buffer.append(opt);
        } else {
            buffer.append(String.valueOf(opt) + '-' + spt);
        }
        buffer.append(',');
        buffer.append(metrics.getSampleCount()).append(',');
        buffer.append(metrics.getByteCount()).append(',');
        buffer.append(metrics.getWorkerCount()).append(',');
        double r = metrics.getAvgResTime();
        if (r > 0.0) {
            buffer.append(Formats.NUM.format(r));
        } else {
            buffer.append("N/A");
        }
        buffer.append(',');
        double pt = r - metrics.getAvgXferTime();
        if (pt > 0.0) {
            buffer.append(Formats.NUM.format(pt));
        } else {
            buffer.append("N/A");
        }
        buffer.append(',');
        CSVMatrixExporter.writeLatencyInfo(buffer, metrics.getLatency());
        buffer.append(Formats.NUM.format(metrics.getThroughput())).append(',');
        buffer.append(Formats.NUM.format(metrics.getBandwidth())).append(',');
        double t = metrics.getRatio();
        if (t > 0.0) {
            buffer.append(Formats.RATIO.format(metrics.getRatio()));
        } else {
            buffer.append("N/A");
        }
        buffer.append(',');
        CSVMatrixExporter.writeConfigInfo(buffer, stage, metrics);
        buffer.setCharAt(buffer.length() - 1, '\n');
        writer.write(buffer.toString());
    }

    private static void writeLatencyInfo(StringBuilder buffer, Histogram latency) throws IOException {
        if (latency == null) {
            CSVMatrixExporter.writePercentileRT(buffer, null);
            CSVMatrixExporter.writePercentileRT(buffer, null);
            CSVMatrixExporter.writePercentileRT(buffer, null);
            CSVMatrixExporter.writePercentileRT(buffer, null);
            CSVMatrixExporter.writePercentileRT(buffer, null);
            CSVMatrixExporter.writePercentileRT(buffer, null);
        } else {
            CSVMatrixExporter.writePercentileRT(buffer, latency.get_60());
            CSVMatrixExporter.writePercentileRT(buffer, latency.get_80());
            CSVMatrixExporter.writePercentileRT(buffer, latency.get_90());
            CSVMatrixExporter.writePercentileRT(buffer, latency.get_95());
            CSVMatrixExporter.writePercentileRT(buffer, latency.get_99());
            CSVMatrixExporter.writePercentileRT(buffer, latency.get_100());
        }
    }

    private static void writePercentileRT(StringBuilder buffer, long[] resTime) {
        if (resTime == null) {
            buffer.append("N/A");
        } else {
            buffer.append(resTime[1]);
        }
        buffer.append(',');
    }

    private static void writeConfigInfo(StringBuilder buffer, StageInfo stage, Metrics metrics) throws IOException {
        for (Work work : stage.getStage()) {
            for (Operation op : work) {
                if (!op.getId().equals(metrics.getOpId())) continue;
                buffer.append(op.getRatio()).append('%').append(' ');
                String config = op.getConfig();
                config = config.replaceAll(",", "-").replaceAll(";", " ");
                buffer.append(config);
            }
        }
        buffer.append(',');
    }
}

