/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Counter;
import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.exporter.AbstractLatencyExporter;
import com.intel.cosbench.exporter.Formats;
import com.intel.cosbench.model.StageInfo;
import java.io.IOException;
import java.io.Writer;

class CSVLatencyExporter
extends AbstractLatencyExporter {
    CSVLatencyExporter() {
    }

    @Override
    protected void writeHeader(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ResTime").append(',');
        StageInfo[] stageInfoArray = this.workload.getStageInfos();
        int n = stageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StageInfo stage = stageInfoArray[n2];
            CSVLatencyExporter.writeOpType(buffer, stage);
            ++n2;
        }
        buffer.setCharAt(buffer.length() - 1, '\n');
        writer.write(buffer.toString());
    }

    private static void writeOpType(StringBuilder buffer, StageInfo stage) {
        for (Metrics metrics : stage.getReport()) {
            String opt = metrics.getOpName();
            String spt = metrics.getSampleType();
            if (!spt.equals(opt)) continue;
            String workName = null;
            int workIdx = 1;
            for (Work work : stage.getStage().getWorks()) {
                if (work.getOperationIDs().contains(metrics.getOpId())) {
                    workName = "w" + workIdx + "-" + work.getName();
                    break;
                }
                ++workIdx;
            }
            buffer.append(String.valueOf(stage.getId()) + "-" + workName + "-" + opt);
            buffer.append(',').append("(%)").append(',');
        }
    }

    @Override
    protected void writeHistogram(Writer writer, int idx) throws IOException {
        StringBuilder buffer = new StringBuilder();
        long[] resTime = Counter.getResTime(idx);
        buffer.append(resTime[0]).append('~');
        if (resTime[1] < Long.MAX_VALUE) {
            buffer.append(resTime[1]);
        } else {
            buffer.append("+INF");
        }
        buffer.append(',');
        int metricsIdx = -1;
        StageInfo[] stageInfoArray = this.workload.getStageInfos();
        int n = stageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StageInfo stage = stageInfoArray[n2];
            for (Metrics metrics : stage.getReport()) {
                ++metricsIdx;
                if (!metrics.getOpName().equals(metrics.getSampleType()) || metrics.getLatency() == null) continue;
                int count = metrics.getLatency().getHistoData()[idx];
                buffer.append(count).append(',');
                int n3 = metricsIdx;
                this.accs[n3] = this.accs[n3] + count;
                double per = this.sums[metricsIdx] != 0 ? (double)this.accs[metricsIdx] / (double)this.sums[metricsIdx] : 0.0;
                buffer.append(Formats.RATIO.format(per)).append(',');
            }
            ++n2;
        }
        buffer.setCharAt(buffer.length() - 1, '\n');
        writer.write(buffer.toString());
    }
}

