/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.exporter.WorkloadExporter;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.IOException;
import java.io.Writer;

abstract class AbstractWorkloadExporter
implements WorkloadExporter {
    protected WorkloadInfo workload;

    public void setWorkload(WorkloadInfo workload) {
        this.workload = workload;
    }

    @Override
    public void export(Writer writer) throws IOException {
        this.writeHeader(writer);
        writer.flush();
        StageInfo[] stageInfoArray = this.workload.getStageInfos();
        int n = stageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StageInfo stage = stageInfoArray[n2];
            for (Metrics metrics : stage.getReport()) {
                this.writeMetrics(writer, metrics, stage);
            }
            if (stage.getReport().getSize() == 0) {
                this.writeMetrics(writer, stage);
            }
            ++n2;
        }
        writer.flush();
    }

    protected abstract void writeMetrics(Writer var1, StageInfo var2) throws IOException;

    protected abstract void writeHeader(Writer var1) throws IOException;

    protected abstract void writeMetrics(Writer var1, Metrics var2, StageInfo var3) throws IOException;
}

