/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.exporter.WorkerExporter;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.TaskInfo;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractWorkerExporter
implements WorkerExporter {
    private StageInfo stageInfo;

    public StageInfo getStageInfo() {
        return this.stageInfo;
    }

    public void setStageInfo(StageInfo stageInfo) {
        this.stageInfo = stageInfo;
    }

    @Override
    public void export(Writer writer) throws IOException {
        this.writeReport(writer);
    }

    private void writeReport(Writer writer) throws IOException {
        this.writeHeader(writer);
        writer.flush();
        TaskInfo[] taskInfoArray = this.stageInfo.getTaskInfos();
        int n = taskInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskInfo taskInfo = taskInfoArray[n2];
            for (Metrics metrics : taskInfo.getWrReport()) {
                this.writeMetrics(writer, metrics);
            }
            ++n2;
        }
        writer.flush();
    }

    protected abstract void writeHeader(Writer var1) throws IOException;

    protected abstract void writeMetrics(Writer var1, Metrics var2) throws IOException;
}

